DELIMITER $$
DROP PROCEDURE IF EXISTS V20200327201332__Create_id_format_counter_intake_year $$
CREATE PROCEDURE V20200327201332__Create_id_format_counter_intake_year()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='id_format_counter_intake_year')) THEN 
CREATE TABLE `id_format_counter_intake_year` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `currentCounter` BIGINT(40) NULL,
  `intakeYear` INT NULL,
  `idDefinition` BIGINT NULL,
  `startingPoint` BIGINT(40) NULL,
  `lastUpdate` TIMESTAMP NULL,
  `lastUpdatedBy` BIGINT NULL,
  `noOfDigits` INT(10) NULL,
  PRIMARY KEY (`id`),
  INDEX `counter_intake_id_defination_idx` (`idDefinition` ASC),
  INDEX `counter_user_intake_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `counter_intake_id_defination`
    FOREIGN KEY (`idDefinition`)
    REFERENCES `id_definition` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `counter_user_intake`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20200327201332__Create_id_format_counter_intake_year () $$ 
DROP PROCEDURE IF EXISTS V20200327201332__Create_id_format_counter_intake_year $$ 
DELIMITER ;