DELIMITER $$
DROP PROCEDURE IF EXISTS V20200330200344__Update_ApplicationIDForAppointment $$
CREATE PROCEDURE V20200330200344__Update_ApplicationIDForAppointment()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='APPOINTMENT_RECIPIENT')) THEN 

SET @sgAppointmentDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPOINTMENT_RECIPIENT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
	(Case
        when T3.code is null then enq.code
        else T3.code
    end) as ENQ_CODE,
    T1.appointeeName AS PRINT_NAME,
    T1.appointeeEmailId AS EMAIL_ID,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    TRIM(SUBSTRING_INDEX(personToMeet, '/', - 1)) AS PERSON_TO_MEET,
    TRIM(SUBSTRING_INDEX(appointeeContactNo, '-', 1)) AS MOBILE_CODE,
    TRIM(SUBSTRING_INDEX(appointeeContactNo, '-', - 1)) AS MOBILE_NO,
    TRIM(SUBSTRING_INDEX(appointeeName, '/', - 1)) AS FIRST_NAME,
	T2.academyName AS ACADEMY_NAME,
    T2.locationName AS LOCATION_NAME,
    T2.displayName AS ACADEMY_NAME_LOCATION,
    (Case 
    when T2.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T2.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T2.logoUrl)end) as LOGO_URL,
    (Case when T2.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T2.headerUrl) 
    else NULL end) as HEADER_URL,
	(Case when T2.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T2.footerUrl) 
    else NULL end) as FOOTER_URL
FROM
    sg_appointment T1
        LEFT JOIN
    academy_location T2 ON T2.id = T1.academyLocationId
		LEFT JOIN
    application T3 ON T3.id = T1.applicationId
   		LEFT JOIN
    organizations org on org.id = 1
		LEFT JOIN
    enquiry enq on enq.id = T1.enquiryId
WHERE
    T1.id IN (namedParams)",`jsonString` = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "visitTime",
            "resultKey": "VISIT_TIME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "FIRST_NAME",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "PERSON_TO_MEET",
            "resultKey": "PERSON_TO_MEET",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "appointeeName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },        
        {
            "id": 6,
            "value": "APPOINTMENT_DATE",
            "resultKey": "APPOINTMENT_DATE",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "code",
            "resultKey": "ENQ_CODE",
            "displayCode": "",
            "displayOrder": 12
        }
    ]
}' WHERE `dataProviderId` = @sgAppointmentDT;

END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20200330200344__Update_ApplicationIDForAppointment () $$
DROP PROCEDURE IF EXISTS V20200330200344__Update_ApplicationIDForAppointment $$
DELIMITER ;