DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402143318__Create_manage_target_view $$
CREATE PROCEDURE V20200402143318__Create_manage_target_view()
BEGIN

IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'manage_target_view')) THEN 
DROP view `manage_target_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'manage_target_view')) THEN 
CREATE OR REPLACE VIEW `manage_target_view` AS select 
        `academyloc5_`.`id` AS `ACADEMY_LOCATION_ID`,
        `this_`.`enrolmentTarget` AS `enrollmentTarget`,
        `this_`.`enrolmentPreviousYear` AS `enrollmentPreYear`,
        `program1_`.`programName` AS `programName`,
        `this_`.`enquiryTarget` AS `enquiryTarget`,
        `this_`.`applicationTarget` AS `applicationTarget`,
        `programgro4_`.`groupName` AS `programGroupName`,
        `intakeyear3_`.`id` AS `intakeYearId`,
        `this_`.`buildingCapacitySpecialist` AS `buildingCapacitySpecialist`,
        `batch2_`.`id` AS `batchId`,
        `batch2_`.`batchName` AS `batchName`,
        `programgro4_`.`id` AS `programGroupId`,
        `this_`.`revisedBudget` AS `revisedBudget`,
        `managingdi7_`.`printName` AS `managingDirectorName`,
        `managingdi7_`.`id` AS `managingDirectorId`,
        `academyloc5_`.`displayName` AS `academyLocationDisplayName`,
        `program1_`.`id` AS `PROGRAM_ID`,
        `academy6_`.`academyName` AS `academyName`,
        `intakeyear3_`.`itemCode` AS `intakeYear`,
        `this_`.`enrolmentBudget` AS `enrolmentBudget`,
        `this_`.`buildingCapacity` AS `buildingCapacity`
    from
        ((((((((((`manage_target` `this_`
        left join `academy_location` `academyloc5_` ON ((`this_`.`academyLocationId` = `academyloc5_`.`id`)))
        left join `academies` `academy6_` ON ((`academyloc5_`.`academyId` = `academy6_`.`id`)))
        left join `batches` `batch2_` ON ((`this_`.`batchId` = `batch2_`.`id`)))
        left join `intake_year` `intakeyear3_` ON ((`batch2_`.`intakeYearId` = `intakeyear3_`.`id`)))
        left join `users` `managingdi7_` ON ((`this_`.`managingDirectorId` = `managingdi7_`.`id`)))
        left join `parents` `managingdi7_1_` ON ((`managingdi7_`.`id` = `managingdi7_1_`.`userId`)))
        left join `staffs` `managingdi7_2_` ON ((`managingdi7_`.`id` = `managingdi7_2_`.`userId`)))
        left join `students` `managingdi7_3_` ON ((`managingdi7_`.`id` = `managingdi7_3_`.`userId`)))
        left join `programs` `program1_` ON ((`this_`.`programId` = `program1_`.`id`)))
        left join `program_group` `programgro4_` ON ((`this_`.`programGroupId` = `programgro4_`.`id`)));
END IF; 

END $$
CALL V20200402143318__Create_manage_target_view () $$ 
DROP PROCEDURE IF EXISTS V20200402143318__Create_manage_target_view $$ 
DELIMITER ;