DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402143652__Create_complete_day_attendance_view $$
CREATE PROCEDURE V20200402143652__Create_complete_day_attendance_view()
BEGIN

IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'complete_day_attendance_view')) THEN 
DROP view `complete_day_attendance_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'complete_day_attendance_view')) THEN 
CREATE OR REPLACE VIEW `complete_day_attendance_view` AS select 
        `adm`.`code` AS `admission_Id`,
        `usr`.`code` AS `Student_Id`,
        `pers`.`printName` AS `Student_Name`,
        `pers`.`gender` AS `Gender`,
        `acad`.`academyName` AS `Academy`,
        `loc`.`locationName` AS `Location`,
        `al`.`displayName` AS `Academy_Location`,
        `pgrp`.`groupName` AS `Program_Group`,
        `prg`.`programName` AS `Program`,
        `bch`.`batchName` AS `Batch`,
        `per`.`programPeriodName` AS `Period`,
        `at`.`itemCode` AS `Academic_Term`,
        `sec`.`sectionCode` AS `Section`,
        `spa`.`dateOfAttendance` AS `Attendance_Date`,
        `fac`.`printName` AS `Class_Teacher`,
        `amt`.`itemCode` AS `Marked_Attendance`,
        `amt`.`attendanceStatus` AS `Attendance_Status`,
        `al`.`id` AS `ACADEMY_LOCATION_ID`,
        `prg`.`id` AS `PROGRAM_ID`
    from
        ((((((((((((((((`student_program_attendance` `spa`
        join `student_program_attendance_details` `spad` ON (((`spad`.`attendanceId` = `spa`.`id`)
            and (`spa`.`attendanceType` = 'COMPLETE_DAY'))))
        join `programs` `prg` ON ((`prg`.`id` = `spa`.`programId`)))
        join `program_group` `pgrp` ON ((`pgrp`.`id` = `prg`.`programGroupId`)))
        join `batches` `bch` ON ((`bch`.`id` = `spa`.`batchId`)))
        join `prog_batch_period_config` `per` ON ((`per`.`id` = `spa`.`periodId`)))
        join `sections` `sec` ON ((`sec`.`id` = `spa`.`periodId`)))
        left join `academic_term` `at` ON (((`at`.`id` = `per`.`academicTermId`)
            and (`at`.`whetherCurrentAcademicTerm` = 1))))
        join `admission` `adm` ON ((`adm`.`id` = `spad`.`admissionId`)))
        join `users` `usr` ON ((`usr`.`id` = `adm`.`studentId`)))
        join `academy_location` `al` ON ((`al`.`id` = `prg`.`academyLocationId`)))
        join `academies` `acad` ON ((`al`.`academyId` = `acad`.`id`)))
        join `locations` `loc` ON ((`loc`.`id` = `al`.`locationId`)))
        join `students` `stu` ON ((`stu`.`userId` = `usr`.`id`)))
        join `persons` `pers` ON ((`pers`.`id` = `stu`.`personId`)))
        join `users` `fac` ON ((`fac`.`id` = `spa`.`facultyId`)))
        join `attendance_marking_type` `amt` ON ((`amt`.`id` = `spad`.`attendanceMarkingTypeId`)))
    where
        (`spa`.`dateOfAttendance` >= (now() - interval 3 month));
END IF; 

END $$
CALL V20200402143652__Create_complete_day_attendance_view () $$ 
DROP PROCEDURE IF EXISTS V20200402143652__Create_complete_day_attendance_view $$ 
DELIMITER ;