DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402150601__Create_course_pending_attendance $$
CREATE PROCEDURE V20200402150601__Create_course_pending_attendance()
BEGIN

IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'course_pending_attendance')) THEN 
DROP view `course_pending_attendance`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'course_pending_attendance')) THEN 
CREATE OR REPLACE VIEW `course_pending_attendance` AS
    SELECT
        `al`.`academyName` AS `Academy`,
        `al`.`locationName` AS `LocatioName`,
	`al`.`id` AS `Academy Location Id`,
        `at`.`itemValue` AS `AcademicTerm`,
        `cd`.`deptName` AS `Department`,
        `cou`.`courseCode` AS `Course Code`,
        `cou`.`courseName` AS `Course Name`,
        `ct`.`categoryName` AS `Category Name`,
        `cv`.`courseVariantCode` AS `Course Variant`,
        `fac`.`printName` AS `Faculty`,
        `ccp`.`sessionDate` AS `Attendance Date`,
        `ccp`.`slotFrom` AS `From Time`,
        `ccp`.`slotTo` AS `To Time`,
        (CASE
            WHEN (`ccp`.`studentCourseAttendanceId` <> NULL) THEN 'Yes'
            ELSE 'No'
        END) AS `Attendance_Marked`
    FROM
        (((((((( `course_coverage_plan` `ccp`
        JOIN  `course_variants` `cv` ON ((`cv`.`id` = `ccp`.`courseVariantId`)))
        JOIN  `courses` `cou` ON ((`cou`.`id` = `cv`.`courseId`)))
        JOIN  `academy_location` `al` ON ((`al`.`id` = `ccp`.`academyLocationId`)))
        JOIN  `department` `cd` ON ((`cd`.`id` = `cou`.`departmentId`)))
        JOIN  `course_category` `ct` ON ((`ct`.`id` = `cou`.`courseCategoryId`)))
        JOIN  `sections` `sec` ON ((`sec`.`courseVariantId` = `cv`.`id`)))
        JOIN  `academic_term` `at` ON ((`at`.`id` = `sec`.`academicTermId`)))
        JOIN  `users` `fac` ON ((`fac`.`id` = `ccp`.`facultyId`))) 

where
        (`ccp`.`sessionDate` >= (now() - interval 3 month));
END IF; 

END $$
CALL V20200402150601__Create_course_pending_attendance () $$ 
DROP PROCEDURE IF EXISTS V20200402150601__Create_course_pending_attendance $$ 
DELIMITER ;