DELIMITER $$

DROP PROCEDURE IF EXISTS V20200429112640__Insert_UITranslationForPortal $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200429112640__Insert_UITranslationForPortal()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ACADEMY_LOCATION')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','ACADEMY_LOCATION','Select Academy Location','Select Academy Location',now(),1);
 END IF;
 
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='MODE_OF_DELIVERY')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','MODE_OF_DELIVERY','Mode of Delivery','Mode of Delivery',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='SELECT_PROGRAM_GROUP')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','SELECT_PROGRAM_GROUP','Select Program Group','Select Program Group',now(),1);
 END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='SELECT_PROGRAM')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','SELECT_PROGRAM','Select Program','Select Program',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='REGISTRATION_TYPE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','REGISTRATION_TYPE','Registration Type','Registration Type',now(),1);
 END IF;

END $$

-- Execute the stored procedure
CALL V20200429112640__Insert_UITranslationForPortal() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200429112640__Insert_UITranslationForPortal $$
 
DELIMITER ;