DELIMITER $$
DROP PROCEDURE IF EXISTS V20200506164530__Create_AttainmentRuleAndLevelZurich $$
CREATE PROCEDURE V20200506164530__Create_AttainmentRuleAndLevelZurich()
BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='attainment_rule')) THEN 
		CREATE TABLE `attainment_rule` (
		  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
		  `name` VARCHAR(45) NOT NULL,
		  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
		  `lastUpdatedBy` BIGINT(20) NOT NULL,
		  PRIMARY KEY (`id`),
		  UNIQUE KEY `unique` (`name`),
		  KEY `fk_attainment_rule_lastUpdatedBy` (`lastUpdatedBy`),
		  CONSTRAINT `fk_attainment_rule_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`)
	        REFERENCES `users` (`id`)
        	ON DELETE NO ACTION ON UPDATE NO ACTION) ENGINE=InnoDB DEFAULT CHARSET=utf8;
	END IF; 

	IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='attainment_level')) THEN 
		CREATE TABLE `attainment_level` (
		  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
		  `name` VARCHAR(45) NOT NULL,
		  `levelValue` DOUBLE NOT NULL,
		  `percentageRangeFrom` DOUBLE NOT NULL,
		  `percentageRangeTo` DOUBLE NOT NULL,
		  `attainmentRuleId` BIGINT(20) NOT NULL,
		  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
		  `lastUpdatedBy` BIGINT(20) NOT NULL,
		  PRIMARY KEY (`id`),
		  UNIQUE KEY `attainment_level_unique` (`name`,`attainmentRuleId`,`percentageRangeFrom`,`percentageRangeTo`,`levelValue`),
		  UNIQUE KEY `attainment_level_name_unique` (`name`,`attainmentRuleId`),
		  UNIQUE KEY `attainment_level_percentageRangeFrom_unique` (`percentageRangeFrom`,`attainmentRuleId`),
		  UNIQUE KEY `attainment_level_percentageRangeTo_unique` (`percentageRangeTo`,`attainmentRuleId`),
		  UNIQUE KEY `attainment_level_value_unique` (`levelValue`,`attainmentRuleId`),
		  KEY `fk_attainment_level_attainmentRuleId` (`attainmentRuleId`),
    	  KEY `fk_attainment_level_lastUpdatedBy` (`lastUpdatedBy`),
		  CONSTRAINT `fk_attainment_level_attainmentRuleId` FOREIGN KEY (`attainmentRuleId`)
        	REFERENCES `attainment_rule` (`id`)
        	ON DELETE NO ACTION ON UPDATE NO ACTION,
    	  CONSTRAINT `fk_attainment_level_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`)
	        REFERENCES `users` (`id`)
        	ON DELETE NO ACTION ON UPDATE NO ACTION) ENGINE=InnoDB DEFAULT CHARSET=utf8;
	END IF; 

END $$
CALL V20200506164530__Create_AttainmentRuleAndLevelZurich () $$ 
DROP PROCEDURE IF EXISTS V20200506164530__Create_AttainmentRuleAndLevelZurich $$ 
DELIMITER ;