DELIMITER $$
DROP PROCEDURE IF EXISTS V20200513184627__Create_ForCatalogManagement $$
CREATE PROCEDURE V20200513184627__Create_ForCatalogManagement()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='catalog_management')) THEN 
CREATE TABLE `catalog_management` (
  `id` BIGINT(20) NOT NULL,
  `programId` BIGINT(20) NULL,
  `videoLink` VARCHAR(255) NULL,
  `image` VARCHAR(255) NULL,
  `presentationLanguageId` BIGINT(20) NULL,
  `brochure` VARCHAR(255) NULL,
  `programStructure` VARCHAR(255) NULL,
  `feesStructure` VARCHAR(255) NULL,
  `bursaryInformation` VARCHAR(255) NULL,
  `admissionRequirements` VARCHAR(255) NULL,
  `selectionCriteria` VARCHAR(255) NULL,
   `duration` VARCHAR(255) NULL DEFAULT NULL,
   `fieldOfStudy` VARCHAR(255) NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_catalog_management_1_idx` (`lastUpdatedBy` ASC),
  INDEX `fk_catalog_management_2_idx` (`programId` ASC),
  INDEX `fk_catalog_management_3_idx` (`presentationLanguageId` ASC),
  CONSTRAINT `fk_catalog_management_1`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_catalog_management_2`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_catalog_management_3`
    FOREIGN KEY (`presentationLanguageId`)
    REFERENCES `presentation_Language_master` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);

END IF; 

END $$
CALL V20200513184627__Create_ForCatalogManagement () $$ 
DROP PROCEDURE IF EXISTS V20200513184627__Create_ForCatalogManagement $$ 
DELIMITER ;