DELIMITER $$
DROP PROCEDURE IF EXISTS V20200521150013__Create_Payment_plan $$
CREATE PROCEDURE V20200521150013__Create_Payment_plan()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='payment_plan')) THEN 
CREATE TABLE `payment_plan` (
  `id` bigint NOT NULL,
  `paymentPlanId` varchar(255) NOT NULL,
  `paymentPlanName` varchar(255) NOT NULL,
  `isInherited` bit(1) NOT NULL,
  `currencyId` bigint NOT NULL,
  `noOfInstallments` bigint NOT NULL,
  `validTill` date DEFAULT NULL,
  `parentPaymentPlanId` bigint DEFAULT NULL,
  `isEnrollmentFromPortal` bit(1) DEFAULT NULL,
  `enrollmentStartDate` date DEFAULT NULL,
  `enrollmentEndDate` date DEFAULT NULL,
  `isPlanChangePossible` bigint DEFAULT NULL,
  `plancChangeFromDate` date DEFAULT NULL,
  `planChangeTillDate` date DEFAULT NULL,
  `isPlanChangePossibleFromPortal` bit(1) DEFAULT NULL,
  `isFineApplicable` bit(1) DEFAULT NULL,
  `fineRule` varchar(255) DEFAULT NULL,
  `planStatus` varchar(255) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_plan_to_currency_idx` (`currencyId`),
  KEY `payment_plan_to_user_idx` (`lastUpdatedBy`),
  KEY `payment_plan_to_payment_plan_idx` (`parentPaymentPlanId`),
  CONSTRAINT `payment_plan_to_currency` FOREIGN KEY (`currencyId`) REFERENCES `currency` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `payment_plan_to_payment_plan` FOREIGN KEY (`parentPaymentPlanId`) REFERENCES `payment_plan` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `payment_plan_to_user` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
);
END IF; 

END $$
CALL V20200521150013__Create_Payment_plan () $$ 
DROP PROCEDURE IF EXISTS V20200521150013__Create_Payment_plan $$ 
DELIMITER ;