DELIMITER $$

DROP PROCEDURE IF EXISTS V20200604155030__InsertHostelReqSetup $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200604155030__InsertHostelReqSetup()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='HOSTEL' and keyName='INSTRUCTIONS_GUIDELINES')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('HOSTEL','INSTRUCTIONS_GUIDELINES','Enter Instructions / Guidelines to be displayed','Enter Instructions / Guidelines to be displayed',now(),1);
 END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='HOSTEL' and keyName='UPLOAD_GUIDELINE_DOCUMENT')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('HOSTEL','UPLOAD_GUIDELINE_DOCUMENT','Upload Guidelines Document','Upload Guidelines Document', now(),1);

  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='FILL_FORM_FIELD_DETAILS')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','FILL_FORM_FIELD_DETAILS','Please fill the form details','Please fill the form details', now(),1);

  END IF;


END $$

-- Execute the stored procedure
CALL V20200604155030__InsertHostelReqSetup() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200604155030__InsertHostelReqSetup $$
 
DELIMITER ;