DELIMITER $$
DROP PROCEDURE IF EXISTS V20200608182123__Create_TableCourseCESM $$
CREATE PROCEDURE V20200608182123__Create_TableCourseCESM()
BEGIN

IF NOT EXISTS (((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='course_cesm_code'))) THEN 
CREATE TABLE IF NOT EXISTS `course_cesm_code` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`programGroupCESMId` BIGINT(20) NOT NULL,
    `programCESMId` BIGINT(20) NOT NULL,
	`courseCESMId` VARCHAR(255) NOT NULL,
	`courseCESMValue` VARCHAR(255) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	 UNIQUE INDEX `course_cesm_code_UNIQUE` (`courseCESMId` ASC),
	   UNIQUE INDEX `course_cesm_code_UNIQUE1` (`courseCESMValue` ASC),
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
	FOREIGN KEY (`programGroupCESMId`) REFERENCES `program_group_cesm`(`id`),
   FOREIGN KEY (`programCESMId`) REFERENCES `program_cesm`(`id`)

) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'COURSE_CESM_CODE')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'course_cesm_code','COURSE_CESM_CODE','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;



SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'PROGRAM_GROUP_CESM_ID')) THEN
INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'programGroupCESM', 'PROGRAM_GROUP_CESM_ID', @standardMasterMaxId+1, 'Varchar', '1', b'1', 'program_group_cesm', 'id', 'value', b'0', b'0', b'0', '1', SYSDATE());
END IF;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'PROGRAM_CESM_ID')) THEN
INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'programCESM', 'PROGRAM_CESM_ID', @standardMasterMaxId+1, 'Varchar', '2', b'1', 'program_cesm', 'id', 'value', b'0', b'0', b'0', '1', SYSDATE());
END IF;



SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'Course_CESM_ID')) THEN
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `maxLength`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'courseCESMId', 'COURSE_CESM_ID', @standardMasterMaxId+1, 'varchar', '3', 0, 0, 0, 0, '100', '1', SYSDATE());
END IF;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'COURSE_CESM_VALUE')) THEN
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `maxLength`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'courseCESMValue', 'COURSE_CESM_VALUE', @standardMasterMaxId+1, 'varchar', '4', 0, 0, 0, 0, '100', '1', SYSDATE());



INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) VALUES ('masterNames','COURSE_CESM_CODE','Course CESM Code','Course CESM Code',now(),1);



INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) VALUES ('PROGRAMANDCOURSE','COURSE_CESM_ID','Course CESM ID','Course CESM ID',now(),1);



INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) VALUES ('PROGRAMANDCOURSE','COURSE_CESM_VALUE','Course CESM Value','Course CESM Value',now(),1);

END IF;

END $$
CALL V20200608182123__Create_TableCourseCESM () $$ 
DROP PROCEDURE IF EXISTS V20200608182123__Create_TableCourseCESM $$ 
DELIMITER ;
