DELIMITER $$
DROP PROCEDURE IF EXISTS V20200616143605__Alter_periodTable $$
CREATE PROCEDURE V20200616143605__Alter_periodTable()
BEGIN

IF EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='prog_batch_period_config')) THEN 
ALTER TABLE `prog_batch_period_config` 
ADD COLUMN `periodYearId` BIGINT(20) NULL DEFAULT NULL AFTER `droolId`,
ADD INDEX `fk_period_year` (`periodYearId` ASC),
ADD CONSTRAINT `fk_period_year`
  FOREIGN KEY (`periodYearId`)
  REFERENCES `period_year` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD COLUMN `minimumCreditsForPromotion` FLOAT NULL DEFAULT NULL AFTER `periodYearId`,
ADD COLUMN `minimumCGPAForPromotion` FLOAT NULL DEFAULT NULL AFTER `minimumCreditsForPromotion`;
END IF; 

END $$
CALL V20200616143605__Alter_periodTable() $$
DROP PROCEDURE IF EXISTS V20200616143605__Alter_periodTable $$
DELIMITER ;