DELIMITER $$
DROP PROCEDURE IF EXISTS V20200616165105__Create_EducationInterventions $$
CREATE PROCEDURE V20200616165105__Create_EducationInterventions()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_person_education_interventions')) THEN

CREATE TABLE `applicant_person_education_interventions` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `educationInterventionsId` BIGINT(20) NOT NULL,
  `applicantPersonId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_applicant_person_interventions_idx` (`educationInterventionsId` ASC),
  INDEX `fk_applicant_person_Id_idx` (`applicantPersonId` ASC),
  INDEX `fk_applicant_person_interventions_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_applicant_person_interventions_id`
    FOREIGN KEY (`educationInterventionsId`)
    REFERENCES `drop_down` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_applicant_person_interventions_applicantId`
    FOREIGN KEY (`applicantPersonId`)
    REFERENCES `applicant_person` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_applicant_person_interventions_lastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 


IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='person_education_interventions')) THEN

 CREATE TABLE `person_education_interventions` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `educationInterventionsId` BIGINT(20) NOT NULL,
  `personId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_person_interventions_idx` (`educationInterventionsId` ASC),
  INDEX `fk_person_interventions_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  INDEX `fk_person_Id_idx` (`personId` ASC),
  CONSTRAINT `fk_person_interventions_id`
    FOREIGN KEY (`educationInterventionsId`)
    REFERENCES `drop_down` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_person_interventions_personId`
    FOREIGN KEY (`personId`)
    REFERENCES `persons` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_person_interventions_lastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20200616165105__Create_EducationInterventions () $$ 
DROP PROCEDURE IF EXISTS V20200616165105__Create_EducationInterventions $$ 
DELIMITER ;