DELIMITER $$
DROP PROCEDURE IF EXISTS V20200624160419__Update_dataproviderForMsgMultiLanguage $$
CREATE PROCEDURE V20200624160419__Update_dataproviderForMsgMultiLanguage()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='CLINIC_APPOINTMENT_PARENT_RCPNT')) THEN 
SET @clinicDtProviderId1=(SELECT id FROM dtprovider WHERE `dataProviderName`='CLINIC_APPOINTMENT_PARENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    pid.id AS ID,
    perPer.`firstName` AS FIRST_NAME,
    perPer.`lastName` AS LAST_NAME,
    perPer.printName AS PRINT_NAME,
    perPer.`emailId` AS EMAIL_ID,
    perPer.`mobileNumber` AS MOBILE_NO,
    doc.printName AS DOC_PRINT_NAME,
    doc.firstName AS DOC_FIRST_NAME,
    doc.lastName AS DOC_LAST_NAME,
    stu.printName AS STUDENT_PRINT_NAME,
    stu.firstName AS STUDENT_FIRST_NAME,
    stu.lastName AS STUDENT_LAST_NAME,
    T2.sectionCode AS SECTION_CODE,
    infRes.itemValue AS REASON,
    DATE_FORMAT(T1.infirmaryDate, '%d-%m-%Y') AS VISIT_DATE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
    ml.code AS LANGUAGE_KEY,
    (SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info f
        WHERE
            parent.userId = f.userId) AS DEVICE_ID,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL
FROM
    infirmary_details T1
		INNER JOIN
    parent_infirmary_details pid ON pid.infirmaryId = T1.id
        LEFT JOIN
    sections T2 ON T2.id = T1.sectionId
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T1.academyLocationId
        LEFT JOIN
    users doc ON doc.id = T1.doctorUserId        
        LEFT JOIN
    users stu ON stu.id = T1.userId
        LEFT JOIN
    infirmary_reason infRes ON infRes.id = T1.infirmaryReasonId        
		LEFT JOIN
    persons perPer ON perPer.id = pid.personId
        LEFT JOIN
    parents parent ON parent.personId = perPer.id
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT MAX(id) FROM organizations)
        LEFT JOIN 
    multi_language ml on perPer.correspondence_language = ml.id
WHERE
    pid.id IN (namedParams)
        AND T1.type = 'CLINIC'" WHERE `dataProviderId`=@clinicDtProviderId1; 
END IF; 

IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='CLINIC_APPOINTMENT_FACULTY_RCPNT')) THEN 
SET @intervDtProviderId1=(SELECT id FROM dtprovider WHERE `dataProviderName`='CLINIC_APPOINTMENT_FACULTY_RCPNT');


UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    autPer.`firstName` AS FIRST_NAME,
    autPer.`lastName` AS LAST_NAME,
    autPer.printName AS PRINT_NAME,
    autPer.`emailId` AS EMAIL_ID,
    autPer.`mobileNumber` AS MOBILE_NO,
    doc.printName AS DOC_PRINT_NAME,
    doc.firstName AS DOC_FIRST_NAME,
    doc.lastName AS DOC_LAST_NAME,
    stu.printName AS STUDENT_PRINT_NAME,
    stu.firstName AS STUDENT_FIRST_NAME,
    stu.lastName AS STUDENT_LAST_NAME,
	T2.sectionCode AS SECTION_CODE,
    ml.code as LANGUAGE_KEY,
	infRes.itemValue AS REASON,
    DATE_FORMAT(T1.infirmaryDate, '%d-%m-%Y') AS VISIT_DATE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where s.userId = f.userId)  AS DEVICE_ID,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL
FROM
    infirmary_details T1
        LEFT JOIN
    sections T2 ON T2.id = T1.sectionId
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T1.academyLocationId
        LEFT JOIN
    users doc ON doc.id = T1.doctorUserId
        LEFT JOIN
    users authority ON authority.id = T1.authorityUserId
        LEFT JOIN
    staffs s ON s.userId = authority.id
        LEFT JOIN
    persons autPer ON autPer.id = s.personId
        LEFT JOIN
    users stu ON stu.id = T1.userId
 		LEFT JOIN
    infirmary_reason infRes on infRes.id = T1.infirmaryReasonId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
         LEFT JOIN
    multi_language ml on autPer.correspondence_language=ml.id
WHERE
    T1.id IN (namedParams) and T1.type = 'CLINIC'" WHERE `dataProviderId`=@intervDtProviderId1; 
END IF; 


IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='ADD_EXTERNAL_USER_RECIPIENT_INFO')) THEN 
SET @dtProviderId2=(SELECT id FROM dtprovider WHERE `dataProviderName`='ADD_EXTERNAL_USER_RECIPIENT_INFO');


UPDATE `sql_dtprovider` SET `sqlQuery`="select T1.id as ID,
	T4.`firstName` AS FIRST_NAME,
	T4.`lastName` AS LAST_NAME,
    T4.`emailId` AS EMAIL_ID,
	T4.`mobileNumber` AS MOBILE_NO,
	T4.`mobileCountryCode` AS MOBILE_CODE,
        ml.code AS LANGUAGE_KEY
 from external_users T1
	left join external_user_association T2 on T2.externalUserId=T1.id
    left join application T3 on T3.id=T2.applicationId
    left join applicant_person T4 on T4.id=T3.applicantPersonId 
    left join multi_language ml on T4.correspondence_language=ml.id
    where T1.id in (namedParams)" WHERE `dataProviderId`=@dtProviderId2;   
END IF;



IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_BIRTHDAY_GREETING_RCPNT')) THEN 
 SET @clinicDtProviderId11=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_BIRTHDAY_GREETING_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="select ID,BIRTH_DATE,SALUTATION_NAME,FIRST_NAME,MIDDLE_NAME,LAST_NAME,EMAIL_ID,MOBILE_NO,MOBILE_CODE,group_concat(DEVICE_ID) AS DEVICE_ID ,LANGUAGE_KEY from
(
	select 
		s.userId as ID,
        p.birthDate as BIRTH_DATE,
        sal.salutationName as SALUTATION_NAME,
        p.firstName as FIRST_NAME,
        p.middleName as MIDDLE_NAME,
        p.lastName as LAST_NAME,
        p.emailId as EMAIL_ID,
        p.mobileNumber as MOBILE_NO,
        p.mobileCountryCode as MOBILE_CODE,
        f.deviceTokenId AS DEVICE_ID,
		ml.code as LANGUAGE_KEY
	from 
		students s
		inner join users u on u.id = s.userId
		inner join persons p on p.id = s.personId
		left join salutations sal on sal.id = p.salutationId
        LEFT JOIN fire_base_persons_info f ON f.userId = s.userId
		left join multi_language ml on p.correspondence_language=ml.id
	UNION
	select 
		s.userId as ID,
        p.birthDate as BIRTH_DATE,
        sal.salutationName as SALUTATION_NAME,
        p.firstName as FIRST_NAME,
        p.middleName as MIDDLE_NAME,
        p.lastName as MIDDLE_NAME,
        p.emailId as EMAIL_ID,
        p.mobileNumber as MOBILE_NO,
        p.mobileCountryCode as MOBILE_CODE,
        f.deviceTokenId AS DEVICE_ID,
		ml.code as LANGUAGE_KEY
	from 
		staffs s
		inner join users u on u.id = s.userId
		inner join persons p on p.id = s.personId
		left join salutations sal on sal.id = p.salutationId
		LEFT JOIN fire_base_persons_info f ON f.userId = u.id
		left join multi_language ml on p.correspondence_language=ml.id
) as PSEUDO
 where date_format(BIRTH_DATE,'%m-%d') = date_format(now(),'%m-%d')" WHERE `dataProviderId`=@clinicDtProviderId11;    
END IF;

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20200624160419__Update_dataproviderForMsgMultiLanguage () $$
DROP PROCEDURE IF EXISTS V20200624160419__Update_dataproviderForMsgMultiLanguage $$
DELIMITER ;