DELIMITER $$
DROP PROCEDURE IF EXISTS V20200722110001__Create_EmployeeJobPostingLocation $$
CREATE PROCEDURE V20200722110001__Create_EmployeeJobPostingLocation()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='employee_job_posting_location')) THEN 
CREATE TABLE `employee_job_posting_location`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`employeeJobPostingId` BIGINT(20) NOT NULL,
	`academyLocationId` BIGINT(20) NOT NULL,
    `departmentId` BIGINT(20) NOT NULL,
    `designationId` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	UNIQUE KEY `unique_ejpl_dept_designtn_index` (`employeeJobPostingId`,`academyLocationId`,`departmentId`,`designationId`),
	INDEX `fk_employee_job_posting_location_1_idx` (`employeeJobPostingId` ASC),
    INDEX `fk_employee_job_posting_location_2_idx` (`academyLocationId` ASC),
    INDEX `fk_employee_job_posting_location_3_idx` (`departmentId` ASC),
    INDEX `fk_employee_job_posting_location_4_idx` (`designationId` ASC),
    CONSTRAINT `fk_employee_job_posting_location_ejpId`
	FOREIGN KEY (`employeeJobPostingId`) REFERENCES `employee_job_posting`(`id`)
	ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_employee_job_posting_location_alId`
	FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location`(`id`)
	ON DELETE NO ACTION
    ON UPDATE NO ACTION,
     CONSTRAINT `fk_employee_job_posting_location_designtnId`
	FOREIGN KEY (`designationId`) REFERENCES `designations`(`id`)
	ON DELETE NO ACTION
    ON UPDATE NO ACTION,
     CONSTRAINT `fk_employee_job_posting_location_deptId`
	FOREIGN KEY (`departmentId`) REFERENCES `department`(`id`)
	ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_employee_job_posting_location_usrId`
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
	ON DELETE NO ACTION
    ON UPDATE NO ACTION
);
END IF; 

END $$
CALL V20200722110001__Create_EmployeeJobPostingLocation () $$ 
DROP PROCEDURE IF EXISTS V20200722110001__Create_EmployeeJobPostingLocation $$ 
DELIMITER ;