DROP procedure IF EXISTS `search_config_app_data_update`;

DELIMITER $$
CREATE PROCEDURE `search_config_app_data_update`(in searchConfigId BigInt, in newSearchConfigId BigInt)
BEGIN
declare search_result_view_column_no_more_rows boolean default false;
declare saved_search_criteria_no_more_rows boolean default false;
declare vsearchResultViewColumnId, vsavedsearchCriteriaId, vsearchConfigTableId, vsearchTableId, vjoinClause, vdisplayOrder, vNewsearchConfigTableId bigint;
declare valias, vdisplayCode, vjoinType varchar(255);
declare vwhetherSubQuery, vavailableForCriteriaSearch bit;
-- drop temporary table if exists templog_searchConfigApp;
-- create temporary table templog_searchConfigApp (msg varchar(8192));
START TRANSACTION;
BLOCK1: begin
set FOREIGN_KEY_CHECKS = 0;
SET SQL_SAFE_UPDATES = 0;
-- -- insert into templog_searchConfigApp values(concat('Start searchConfigId- ',searchConfigId, ', newSearchConfigId-', newSearchConfigId));
set @basicSearchConfigId = (select GROUP_CONCAT(id) from basic_search_config where basic_search_config.searchConfigId = searchConfigId);
-- -- insert into templog_searchConfigApp values(concat('1','@basicSearchConfigId- ',@basicSearchConfigId));
set @dropSearchResultViewId = (select GROUP_CONCAT(id) from search_result_view where search_result_view.searchConfigId = searchConfigId and search_result_view.viewCode in (select viewCode from search_result_view where search_result_view.searchConfigId = NewSearchConfigId));
-- insert into templog_searchConfigApp values(concat('2','@dropSearchResultViewId- ',@dropSearchResultViewId));
update `saved_search` set saved_search.searchConfigId = newSearchConfigId where saved_search.searchConfigId = searchConfigId and id>0;
-- insert into templog_searchConfigApp values(concat('3','update saved_search'));
delete from `search_sql_groupby` where search_sql_groupby.searchResultViewColumnId in(select id from `search_result_view_column` where find_in_set(searchResultViewId, @dropSearchResultViewId));
-- insert into templog_searchConfigApp values(concat('4','delete search_sql_groupby'));
delete from `search_sql_group` where find_in_set(searchResultViewId, @dropSearchResultViewId);
-- insert into templog_searchConfigApp values(concat('5','delete search_sql_group'));
delete from `search_result_view_sort` where find_in_set(searchResultViewId, @dropSearchResultViewId);
-- insert into templog_searchConfigApp values(concat('6','delete search_result_view_sort'));
delete from `search_result_view_column` where find_in_set(searchResultViewId, @dropSearchResultViewId);
-- insert into templog_searchConfigApp values(concat('7','delete search_result_view_column'));
delete from `search_result_view` where find_in_set(id, @dropSearchResultViewId);
-- insert into templog_searchConfigApp values(concat('8','delete search_result_view'));
update `search_result_view` set search_result_view.searchConfigId = newSearchConfigId where search_result_view.searchConfigId=searchConfigId and id>0;
-- insert into templog_searchConfigApp values(concat('9','update search_result_view'));
delete from `search_implicit_criteria` where search_implicit_criteria.searchConfigId = searchConfigId;
-- insert into templog_searchConfigApp values(concat('10','delete search_implicit_criteria'));
delete from `search_result_enhancer` where search_result_enhancer.searchConfigId = searchConfigId;
-- insert into templog_searchConfigApp values(concat('11','delete search_result_enhancer'));
BLOCK2: begin
DECLARE search_result_view_column_data CURSOR FOR
select srvc.id, srvc.searchConfigTableId, sct.searchTableId, sct.joinClause, sct.displayOrder, sct.alias, sct.displayCode, sct.whetherSubQuery, sct.joinType, sct.availableForCriteriaSearch from `search_result_view_column` as srvc
join search_config_table as sct on srvc.searchConfigTableId = sct.id where
sct.searchConfigId = searchConfigId;
declare continue handler for not found  set search_result_view_column_no_more_rows := true;
OPEN search_result_view_column_data;
search_result_view_column_data: LOOP
fetch search_result_view_column_data into vsearchResultViewColumnId, vsearchConfigTableId, vsearchTableId, vjoinClause, vdisplayOrder, valias, vdisplayCode, vwhetherSubQuery, vjoinType, vavailableForCriteriaSearch;
-- insert into templog_searchConfigApp values(concat(search_result_view_column_no_more_rows,'new data faching',vsearchResultViewColumnId));
if search_result_view_column_no_more_rows then set search_result_view_column_no_more_rows := false;
        close search_result_view_column_data;
        leave search_result_view_column_data;
end if;
set vNewsearchConfigTableId := (select id from search_config_table as sct where sct.searchTableId = vsearchTableId and sct.searchConfigId = newSearchConfigId and (sct.joinClause = vjoinClause or (sct.joinClause is null and vjoinClause is null))and (sct.displayOrder = vdisplayOrder or (sct.displayOrder is null and vdisplayOrder is null)) and sct.alias = valias and sct.displayCode = vdisplayCode and sct.whetherSubQuery = vwhetherSubQuery and (sct.joinType = vjoinType or (sct.joinType is null and vjoinType is null)) and sct.availableForCriteriaSearch = vavailableForCriteriaSearch);
if(vNewsearchConfigTableId is not null) then
update search_result_view_column as srvc set searchConfigTableId=vNewsearchConfigTableId where srvc.id = vsearchResultViewColumnId;
-- else 
-- insert into templog_searchConfigApp values(concat('vsearchResultViewColumnId empty',vsearchResultViewColumnId));
end if;
END LOOP search_result_view_column_data;
END BLOCK2;

BLOCK3: begin
DECLARE saved_search_criteria_data CURSOR FOR
select ssc.id, ssc.searchConfigTableId, sct.searchTableId, sct.joinClause, sct.displayOrder, sct.alias, sct.displayCode, sct.whetherSubQuery, sct.joinType, sct.availableForCriteriaSearch from `saved_search_criteria` as ssc
join search_config_table as sct on ssc.searchConfigTableId = sct.id where
sct.searchConfigId = searchConfigId;
declare continue handler for not found  set saved_search_criteria_no_more_rows := true;
OPEN saved_search_criteria_data;
saved_search_criteria_data: LOOP
fetch saved_search_criteria_data into vsavedsearchCriteriaId, vsearchConfigTableId, vsearchTableId, vjoinClause, vdisplayOrder, valias, vdisplayCode, vwhetherSubQuery, vjoinType, vavailableForCriteriaSearch;
-- insert into templog_searchConfigApp values(concat(saved_search_criteria_no_more_rows,'new data faching',vsavedsearchCriteriaId));
if saved_search_criteria_no_more_rows then set saved_search_criteria_no_more_rows := false;
        close saved_search_criteria_data;
        leave saved_search_criteria_data;
end if;
set vNewsearchConfigTableId := (select id from search_config_table as sct where sct.searchTableId = vsearchTableId and sct.searchConfigId = newSearchConfigId and (sct.joinClause = vjoinClause or (sct.joinClause is null and vjoinClause is null))and (sct.displayOrder = vdisplayOrder or (sct.displayOrder is null and vdisplayOrder is null)) and sct.alias = valias and sct.displayCode = vdisplayCode and sct.whetherSubQuery = vwhetherSubQuery and (sct.joinType = vjoinType or (sct.joinType is null and vjoinType is null)) and sct.availableForCriteriaSearch = vavailableForCriteriaSearch);
if(vNewsearchConfigTableId is not null) then
update saved_search_criteria as ssc set searchConfigTableId=vNewsearchConfigTableId where ssc.id = vsavedsearchCriteriaId;
-- else 
-- insert into templog_searchConfigApp values(concat('vsavedsearchCriteriaId empty',vsavedsearchCriteriaId));
end if;
END LOOP saved_search_criteria_data;
END BLOCK3;
delete from `search_config_table` where search_config_table.searchConfigId = searchConfigId;
-- insert into templog_searchConfigApp values(concat('12','delete search_config_table'));
delete from `default_search_criterias` where default_search_criterias.searchConfigId = searchConfigId;
-- insert into templog_searchConfigApp values(concat('13','delete default_search_criterias'));
delete from `basic_search_config_param` where basic_search_config_param.basicSearchConfigId = @basicSearchConfigId;
-- insert into templog_searchConfigApp values(concat('14','delete basic_search_config_param'));
delete from `basic_search_config` where basic_search_config.id = @basicSearchConfigId;
-- insert into templog_searchConfigApp values(concat('15','delete basic_search_config'));
delete from `search_config` where search_config.id = searchConfigId;
-- insert into templog_searchConfigApp values(concat('16','delete search_config'));
SET SQL_SAFE_UPDATES = 1;
SET FOREIGN_KEY_CHECKS = 1;
END BLOCK1;
END$$
DELIMITER ;