DELIMITER $$

CREATE TRIGGER insert_new_modules_AFTER_INSERT

AFTER INSERT

ON applicant_portal_modules FOR EACH ROW
BEGIN
DECLARE setupid integer;
DECLARE maxSeq integer;
 DECLARE done INT DEFAULT FALSE;    	
    	 DECLARE cur CURSOR FOR SELECT DISTINCT setup_id FROM applicant_portal_module_setup;
         DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
        OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO setupid;
           IF done THEN
                LEAVE ins_loop;
            END IF;
            SET maxSeq = (SELECT max(sequenceNo) FROM applicant_portal_module_setup where setup_id = setupid);
            INSERT INTO applicant_portal_module_setup(module_name_id, visibility, mandatory, sequenceNo, new_module_name, setup_id, lastUpdate, lastUpdatedBy)
           VALUES(new.id, 0, 0, maxSeq, null, setupid , now(),1);
        END LOOP;
    CLOSE cur;
    
END$$

DELIMITER ;