DELIMITER $$

DROP PROCEDURE IF EXISTS V20200804192010__InsertUITRNSForReceipt $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200804192010__InsertUITRNSForReceipt()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='RECEIPT_DATE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','RECEIPT_DATE','Receipt Date','Receipt Date','Ontvangsdatum', 'Ngày nhận',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='RECEIPT_NO')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','RECEIPT_NO','Receipt No','Receipt No','Kwitansie no', 'Biên lai số',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='RECEIPT_AMOUNT')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','RECEIPT_AMOUNT','Receipt Amount','Receipt Amount','Ontvangsbedrag', 'Số tiền nhận',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='RECEIPT_TYPE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','RECEIPT_TYPE','Receipt Type','Receipt Type','Kwitansie tipe', 'Loại biên nhận',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='RECEIPT_MODE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','RECEIPT_MODE','Receipt Mode','Receipt Mode','Ontvangsmodus', 'Chế độ nhận',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='VOUCHER_MODE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','VOUCHER_MODE','Voucher Mode','Voucher Mode','Koopbewysmodus', 'Chế độ chứng từ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='RECEIPT_STATUS')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','RECEIPT_STATUS','Status','Status','status', 'trạng thái',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='INSTRUMENT_DETAILS')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','INSTRUMENT_DETAILS','Instrument Details','Instrument Details','Instrumentbesonderhede', 'Chi tiết nhạc cụ',now(),1);
END IF;
 
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'educationform' and formFieldName='examConductedBy')) THEN 
update `form_field_info`
set isMandatory = false
WHERE formAliasName = 'educationform' and formFieldName='examConductedBy';
END IF; 
SET SQL_SAFE_UPDATES=1;

END $$

-- Execute the stored procedure
CALL V20200804192010__InsertUITRNSForReceipt $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200804192010__InsertUITRNSForReceipt $$
 
DELIMITER ;