DELIMITER $$
DROP PROCEDURE IF EXISTS V20200811130531__Insert_PeriodlevelReportRGI $$
CREATE PROCEDURE V20200811130531__Insert_PeriodlevelReportRGI()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'PERIOD_LEVEL_MARKSHEET_REPORT')) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 

VALUES ('10', 'PERIOD_LEVEL_MARKSHEET_REPORT', 'Period Level Marksheet Report', 'PERIOD_LEVEL_MARKSHEET_REPORT.png', 'PERIOD_LEVEL_REPORT_CommonReport.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'PERIOD_LEVEL_MARKSHEET_REPORT.jasper', 'AcademiaLogo.png'); 

set @periodLevel = (select id from report_template where templateCode ='PERIOD_LEVEL_MARKSHEET_REPORT');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@periodLevel, 'TRANS_SR_No', 'Sr. No.', '1', NOW()),
(@periodLevel, 'TRANS_EXAM_ROLL_NUMBER', 'Exam Roll Number', '1', NOW()),
(@periodLevel, 'TRANS_STUDENT_NAME', 'Student\'s Name', '1', NOW()),
(@periodLevel, 'TRANS_TYPE', 'Type', '1', NOW()),
(@periodLevel, 'TRANS_GENDER', 'Gender', '1', NOW()),
(@periodLevel, 'TRANS_MOTHERS_NAME', 'Mother\'s Name', '1', NOW()),
(@periodLevel, 'TRANS_ENROLLMENT_NUMBER', 'Enrollment No.', '1', NOW()),
(@periodLevel, 'TRANS_EXAMINATION', 'Examination', '1', NOW()),
(@periodLevel, 'TRANS_PROGRAM', 'Programme', '1', NOW()),
(@periodLevel, 'TRANS_BATCH', 'Batch', '1', NOW()),
(@periodLevel, 'TRANS_SEMESTER', 'Semester', '1', NOW()),
(@periodLevel, 'TRANS_DEPARTMENT', 'Department', '1', NOW()),
(@periodLevel, 'TRANS_TOTAL_GPV', 'Total GPV', '1', NOW()),
(@periodLevel, 'TRANS_SGPA', 'SGPA', '1', NOW()),
(@periodLevel, 'TRANS_CUMULATIVE_EARNED_CREDITS', 'Cumulative Earned Credits', '1', NOW()),
(@periodLevel, 'TRANS_CUMULATIVE_GPV', 'Cumulative GPV', '1', NOW()),
(@periodLevel, 'TRANS_CGPA', 'CGPA', '1', NOW()),
(@periodLevel, 'TRANS_TOTAL_CREDITS', 'Total Credits', '1', NOW()),
(@periodLevel, 'TRANS_EARNED_CREDITS', 'Earned Credits', '1', NOW()),
(@periodLevel, 'TRANS_RESULT', 'Result', '1', NOW());


END IF; 
END $$
CALL V20200811130531__Insert_PeriodlevelReportRGI() $$
DROP PROCEDURE IF EXISTS V20200811130531__Insert_PeriodlevelReportRGI $$
DELIMITER ;
