DELIMITER $$
DROP PROCEDURE IF EXISTS V20200812193728__Create_DocumentGroupMasterRequired $$
CREATE PROCEDURE V20200812193728__Create_DocumentGroupMasterRequired()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='document_group_master_required')) THEN 
CREATE TABLE `document_group_master_required` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `documentGroupMasterId` BIGINT(20) NOT NULL,
  `documentName` VARCHAR(255) NOT NULL,
  `documentFormat` VARCHAR(45) NULL,
  `size` INT NULL,
  `lastUpdatedBy` BIGINT NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
   PRIMARY KEY (`id`),
   INDEX `fk_dgmr_dgm_id_idx` (`documentGroupMasterId` ASC),
   INDEX `fk_dgmr_user_id_idx` (`lastUpdatedBy` ASC),
   CONSTRAINT `fk_dgmr_dgm_id`
    FOREIGN KEY (documentGroupMasterId)
    REFERENCES `document_group_master` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
   CONSTRAINT `fk_dgmr_user_id`
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20200812193728__Create_DocumentGroupMasterRequired () $$ 
DROP PROCEDURE IF EXISTS V20200812193728__Create_DocumentGroupMasterRequired $$ 
DELIMITER ;