DELIMITER $$
DROP PROCEDURE IF EXISTS V20200817133914__Create_registration_term_setup_detail $$
CREATE PROCEDURE V20200817133914__Create_registration_term_setup_detail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='registration_term_setup_detail')) THEN 
CREATE TABLE `registration_term_setup_detail` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `academicTermId` BIGINT(20) NOT NULL,
  `registrationSetupName` VARCHAR(50) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `registration_setup_name_UNIQUE` (`registrationSetupName` ASC),
  INDEX `fk_academic_Term_idx` (`academicTermId` ASC),
  CONSTRAINT `fk_academic_Term`
    FOREIGN KEY (`academicTermId`)
    REFERENCES `academic_term` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20200817133914__Create_registration_term_setup_detail () $$ 
DROP PROCEDURE IF EXISTS V20200817133914__Create_registration_term_setup_detail $$ 
DELIMITER ;
