DELIMITER $$

DROP PROCEDURE IF EXISTS V20200817141011__Alter_AppPersonAddColumns $$

CREATE PROCEDURE V20200817141011__Alter_AppPersonAddColumns()

BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='applicant_person' AND column_name='isMilitarySponsored')) THEN 
  ALTER TABLE `applicant_person` 
  ADD COLUMN `isMilitarySponsored` BIT(1) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='applicant_person' AND column_name='isBursaryRequirements')) THEN 
  ALTER TABLE `applicant_person` 
  ADD COLUMN `isBursaryRequirements` BIT(1) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='applicant_person' AND column_name='pHDSponsor')) THEN 
  ALTER TABLE `applicant_person` 
  ADD COLUMN `pHDSponsor` VARCHAR(100) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='applicant_person' AND column_name='fieldOfInterest')) THEN 
  ALTER TABLE `applicant_person` 
  ADD COLUMN `fieldOfInterest` BIGINT(20) NULL DEFAULT NULL,
  ADD INDEX `fk_applicant_person_fieldOfInterest_idx` (`fieldOfInterest` ASC);

  ALTER TABLE `applicant_person` 
  ADD CONSTRAINT `fk_applicant_person_fieldOfInterest`
  FOREIGN KEY (`haveDisabilities`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='applicant_person' AND column_name='areaOfResearch')) THEN 
  ALTER TABLE `applicant_person` 
  ADD COLUMN `areaOfResearch` BIGINT(20) NULL DEFAULT NULL,
  ADD INDEX `fk_applicant_person_areaOfResearch_idx` (`areaOfResearch` ASC);
  
  ALTER TABLE `applicant_person`
  ADD CONSTRAINT `fk_applicant_person_areaOfResearch`
  FOREIGN KEY (`areaOfResearch`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
END IF; 

END $$

CALL V20200817141011__Alter_AppPersonAddColumns() $$

DROP PROCEDURE IF EXISTS V20200817141011__Alter_AppPersonAddColumns $$

DELIMITER ;