DELIMITER $$

DROP PROCEDURE IF EXISTS V20200817141029__Alter_PersonAddColumns $$

CREATE PROCEDURE V20200817141029__Alter_PersonAddColumns()

BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' AND column_name='isMilitarySponsored')) THEN 
  ALTER TABLE `persons` 
  ADD COLUMN `isMilitarySponsored` BIT(1) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' AND column_name='isBursaryRequirements')) THEN 
  ALTER TABLE `persons` 
  ADD COLUMN `isBursaryRequirements` BIT(1) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' AND column_name='pHDSponsor')) THEN 
  ALTER TABLE `persons` 
  ADD COLUMN `pHDSponsor` VARCHAR(100) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' AND column_name='fieldOfInterest')) THEN 
  ALTER TABLE `persons` 
  ADD COLUMN `fieldOfInterest` BIGINT(20) NULL DEFAULT NULL,
  ADD INDEX `fk_person_fieldOfInterest_idx` (`fieldOfInterest` ASC);

  ALTER TABLE `persons` 
  ADD CONSTRAINT `fk_person_fieldOfInterest`
  FOREIGN KEY (`haveDisabilities`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' AND column_name='areaOfResearch')) THEN 
  ALTER TABLE `persons` 
  ADD COLUMN `areaOfResearch` BIGINT(20) NULL DEFAULT NULL,
  ADD INDEX `fk_person_areaOfResearch_idx` (`areaOfResearch` ASC);
  
  ALTER TABLE `persons`
  ADD CONSTRAINT `fk_person_areaOfResearch`
  FOREIGN KEY (`areaOfResearch`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
END IF; 

END $$

CALL V20200817141029__Alter_PersonAddColumns() $$

DROP PROCEDURE IF EXISTS V20200817141029__Alter_PersonAddColumns $$

DELIMITER ;