DELIMITER $$
DROP PROCEDURE IF EXISTS V20200819124145__InsertUITranslation $$
CREATE PROCEDURE V20200819124145__InsertUITranslation()
BEGIN

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='RENAME')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','RENAME','Rename','Rename','Naam verander', 'Đổi tên',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='CAMPAIGN_SCHOOL')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','CAMPAIGN_SCHOOL','School Name','School Name','Skool naam', 'Tên trường',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='RECEVING_CURRENCY')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','RECEVING_CURRENCY','Receiving Currency','Receiving Currency','Ontvang geldeenheid', 'Nhận tiền tệ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='PAYMENT_MODE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','PAYMENT_MODE','Payment Mode','Payment Mode','Betaalmodus', 'Phương thức thanh toán',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='INSTRUMENT_NO')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','INSTRUMENT_NO','Instrument No.','Instrument No.','Instrument nr.', 'Số thiết bị',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='INSTRUMENT_DATE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','INSTRUMENT_DATE','Instrument Date','Instrument Date','Instrument Datum', 'Ngày công cụ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='AMOUNT')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','AMOUNT','Amount','Amount','bedrag', 'Số tiền',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='DRAWN_ON_BANK')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','DRAWN_ON_BANK','Drawn on Bank','Drawn on Bank','Drawn on Bank', 'Rút ra trên ngân hàng',now(),1);
END IF;

SET SQL_SAFE_UPDATES=0;

IF EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PROVISIONAL_OFFER_LETTER_ISSUE_DATE')) THEN 
UPDATE `ui_translation` SET `defaultValue`='Provisional Offer Issue Date',
`customerDefineValue`='Provisional Offer Issue Date',
`afriLanguage`='Uitreikingsdatum vir voorlopige aanbod',
`vietLanguage`='Ngày phát hành phiếu mua hàng tạm thời'
WHERE objectName='PORTAL_SETUP_NEW' and keyName='PROVISIONAL_OFFER_LETTER_ISSUE_DATE';
END IF; 

IF EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PROVISIONAL_OFFER_LETTER_WILL_EXPIRE_IN')) THEN 
UPDATE `ui_translation` SET `defaultValue`='Provisional Offer will Expire In',
`customerDefineValue`='Provisional Offer will Expire In',
`afriLanguage`='Die voorlopige aanbod sal verval in',
`vietLanguage`='Ưu đãi tạm thời sẽ hết hạn sau'
WHERE objectName='PORTAL_SETUP_NEW' and keyName='PROVISIONAL_OFFER_LETTER_WILL_EXPIRE_IN';
END IF; 

IF EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='FINAL_OFFER_LETTER_ISSUE_DATE')) THEN 
UPDATE `ui_translation` SET `defaultValue`='Final Offer Issue Date',
`customerDefineValue`='Final Offer Issue Date',
`afriLanguage`='Datum van finale uitreiking',
`vietLanguage`='Ngày phát hành phiếu mua hàng cuối cùng'
WHERE objectName='PORTAL_SETUP_NEW' and keyName='FINAL_OFFER_LETTER_ISSUE_DATE';
END IF; 

IF EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='FINAL_OFFER_LETTER_WILL_EXPIRE_IN')) THEN 
UPDATE `ui_translation` SET `defaultValue`='Final Offer will Expire In',
`customerDefineValue`='Final Offer will Expire In',
`afriLanguage`='Finale aanbod sal verval in',
`vietLanguage`='Ưu đãi cuối cùng sẽ hết hạn sau'
WHERE objectName='PORTAL_SETUP_NEW' and keyName='FINAL_OFFER_LETTER_WILL_EXPIRE_IN';
END IF; 

IF EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ACCEPT_PROVISIONAL_OFFER_LETTER')) THEN 
UPDATE `ui_translation` SET `defaultValue`='Accept Provisional Offer',
`customerDefineValue`='Accept Provisional Offer',
`afriLanguage`='Aanvaar voorlopige aanbod',
`vietLanguage`='Chấp nhận đề nghị tạm thời'
WHERE objectName='PORTAL_SETUP_NEW' and keyName='ACCEPT_PROVISIONAL_OFFER_LETTER';
END IF; 

IF EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DECLINE_PROVISIONAL_OFFER_LETTER')) THEN 
UPDATE `ui_translation` SET `defaultValue`='Decline Provisional Offer',
`customerDefineValue`='Decline Provisional Offer',
`afriLanguage`='Weier voorlopige aanbod',
`vietLanguage`='Từ chối đề nghị tạm thời'
WHERE objectName='PORTAL_SETUP_NEW' and keyName='DECLINE_PROVISIONAL_OFFER_LETTER';
END IF; 

IF EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ACCEPT_FINAL_OFFER_LETTER')) THEN 
UPDATE `ui_translation` SET `defaultValue`='Accept Offer',
`customerDefineValue`='Accept Offer',
`afriLanguage`='Aanvaar aanbod',
`vietLanguage`='Chấp nhận đề nghị'
WHERE objectName='PORTAL_SETUP_NEW' and keyName='ACCEPT_FINAL_OFFER_LETTER';
END IF; 

IF EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DECLINE_FINAL_OFFER_LETTER')) THEN 
UPDATE `ui_translation` SET `defaultValue`='Decline Offer',
`customerDefineValue`='Decline Offer',
`afriLanguage`='Weier aanbod',
`vietLanguage`='Từ chối đề nghị'
WHERE objectName='PORTAL_SETUP_NEW' and keyName='DECLINE_FINAL_OFFER_LETTER';
END IF; 

SET SQL_SAFE_UPDATES=1;

END $$
CALL V20200819124145__InsertUITranslation () $$
DROP PROCEDURE IF EXISTS V20200819124145__InsertUITranslation $$
DELIMITER ;