DELIMITER $$

DROP PROCEDURE IF EXISTS V20200825202515__AlterDataGridConfiguration $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200825202515__AlterDataGridConfiguration()

BEGIN
 
 -- Add the email_address column to the email table, if it doesn't already exist
 IF  EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='data_grid_user_override'
 AND column_name ='applicantId')) THEN
 
 ALTER TABLE `data_grid_user_override`
 DROP FOREIGN KEY `refapplicantId2607`;
 ALTER TABLE `data_grid_user_override`
 DROP COLUMN `applicantId`,
 DROP INDEX `refapplicantId2607_idx` ;

 END IF;
 
 IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='data_grid_user_override'
		 AND column_name ='externalUserId')) THEN
		 
 ALTER TABLE `data_grid_user_override`
 ADD COLUMN `externalUserId` BIGINT NULL DEFAULT NULL AFTER `userId`,
 ADD INDEX `refexternaluser2607_idx` (`externalUserId` ASC);
 ALTER TABLE `data_grid_user_override`
 ADD CONSTRAINT `refexternaluser2607`
  FOREIGN KEY (`externalUserId`)
  REFERENCES `external_users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

END IF;
		 

END $$

-- Execute the stored procedure
CALL V20200825202515__AlterDataGridConfiguration $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200825202515__AlterDataGridConfiguration $$

DELIMITER ;