DELIMITER $$

DROP PROCEDURE IF EXISTS V20200831103856__Create_ConversionMaster $$

CREATE PROCEDURE V20200831103856__Create_ConversionMaster()

BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='conversion_master')) THEN 

		CREATE TABLE `conversion_master` (
  		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  		`examBoardId` BIGINT(20) NULL,
  		`grade` varchar(20) NOT NULL,
		`equivalentMarks` varchar(20) NOT NULL,
		`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		`lastUpdatedBy` bigint(20) NOT NULL,
		PRIMARY KEY (`id`),
		INDEX `fk_conversion_master_exam_board_master_id_idx` (`examBoardId` ASC),
		INDEX `fk_conversion_master_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
	  	CONSTRAINT `fk_conversion_master_exam_board_master_id_idx`
		    FOREIGN KEY (`examBoardId`)
		    REFERENCES `exam_board_master` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT,
	  	CONSTRAINT `fk_conversion_master_lastUpdatedBy_user_id_idx`
		    FOREIGN KEY (`lastUpdatedBy`)
		    REFERENCES `users` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;

	END IF; 
	
	IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'conversion_master')) THEN 

		SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		INSERT INTO `standard_master`(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@standardMasterMaxId+1, 'conversion_master','CONVERSION_MASTER','Program & Courses','COMMON_MASTER',1,0,1,SYSDATE());
		
		SET FOREIGN_KEY_CHECKS=0;
		SET SQL_SAFE_UPDATES = 0;
		SET @standardMasterId=(SELECT id FROM standard_master WHERE `tableName`='conversion_master');
		UPDATE `standard_master` SET `childMaster`=@standardMasterId, `whetherParent`=1 WHERE `tableName`='exam_board_master';
		SET SQL_SAFE_UPDATES = 1;
		SET FOREIGN_KEY_CHECKS=1;
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'grade', 'GRADE', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',SYSDATE());
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'equivalentMarks', 'EQUIVALENT_MARKS', @standardMasterMaxId+1, 'Varchar', '2', 0, 0, 0, 0, '1',SYSDATE());

	END IF; 

END $$

CALL V20200831103856__Create_ConversionMaster () $$

DROP PROCEDURE IF EXISTS V20200831103856__Create_ConversionMaster $$

DELIMITER ;