DELIMITER $$
DROP PROCEDURE IF EXISTS V20200901104454__Create_V522_enquiry_followup_details_view $$
CREATE PROCEDURE V20200901104454__Create_V522_enquiry_followup_details_view()
BEGIN


IF EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'enquiry_followup_details_view')) THEN 
DROP view `enquiry_followup_details_view`;
END IF;


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='enquiry_followup_details_view')) THEN 
Create Or Replace View enquiry_followup_details_view as
select a.Code as Lead_Id, a.EnquiryDate as Leaddate ,CONCAT(coalesce(b.firstName,''), ' ' ,coalesce(b.middleName,'') ,' ' ,coalesce(b.lastName,'')) as Owner, a.status as LeadStatus
,concat(coalesce(c.studentFirstName,'') ,' ',coalesce(c.studentMiddleName,''),' ',coalesce(c.studentLastName,'')) as Student_Name ,
g.id as User_id,g.printName as User_name,d.followUpDate as Follow_Up_Schedule_Date,
d.actualFollowUpDate as Follow_Up_Date ,e.itemCode as Follow_Up_Activity_Type,
d.followupReason_id as Reason_For_Follow_Up_id,f.itemValue as Follow_Up_Activity_Status, d.remark
from enquiry a left join users b on(a.userId = b.id ) left join enq_student_details c on(c.enquiryId=a.id)
left join enq_followup d on(d.enquiryId=a.id )  left join users g on( d.userId=g.id)
left join follow_up_activity_type e on(d.followupActivityTypeId=e.id)
left join follow_up_activity_status f on(d.followupActivityStatusId=f.id);
END IF; 

END $$
CALL V20200901104454__Create_V522_enquiry_followup_details_view () $$ 
DROP PROCEDURE IF EXISTS V20200901104454__Create_V522_enquiry_followup_details_view $$ 
DELIMITER ;