DELIMITER $$
DROP PROCEDURE IF EXISTS V20200927085253__Create_Exam_Cancellation_BMapping $$
CREATE PROCEDURE V20200927085253__Create_Exam_Cancellation_BMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_cancellation_batch_mapping' )) THEN 

CREATE TABLE `exam_cancellation_batch_mapping` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `examCancellationId` BIGINT NOT NULL,
  `batchId` BIGINT NOT NULL,
  `academyLocationId` BIGINT NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `examCancellationBatchMapping_lastUpdatedby` (`lastUpdatedBy` ASC) ,
  INDEX `examCancellationBatchMapping_examcalncancellationId` (`examCancellationId` ASC) ,
  INDEX `exam_cancellation_bm_batchId_idx` (`batchId` ASC) ,
  INDEX `exam_cancellation_bm__academyLocationId_idx` (`academyLocationId` ASC) ,
  CONSTRAINT `exam_cancellation_bm_lastUpdatedBy`
	FOREIGN KEY (`lastUpdatedBy`)
	REFERENCES `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `exam_cancellation_bm_examcancellationId`
	FOREIGN KEY (`examCancellationId`)
	REFERENCES `exam_cancellation` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `exam_cancellation_bm_batchId`
	FOREIGN KEY (`batchId`)
	REFERENCES `batches` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `exam_cancellation_bm_academyLocationId`
	FOREIGN KEY (`academyLocationId`)
	REFERENCES `academy_location` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20200927085253__Create_Exam_Cancellation_BMapping () $$ 
DROP PROCEDURE IF EXISTS V20200927085253__Create_Exam_Cancellation_BMapping $$ 
DELIMITER ;