DELIMITER $$

DROP PROCEDURE IF EXISTS V20200930182135__InsertUITranCatForPortal $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200930182135__InsertUITranCatForPortal()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='YEAR')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','YEAR','Year','Year', 'Jaar','Năm',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='SEMESTER')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','SEMESTER','Semester','Semester', 'Semester','Học kỳ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='NO_DOCUMENT_FOUND')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','NO_DOCUMENT_FOUND','No Document Found','No Document Found', 'Geen dokument gevind nie','Không tìm thấy tài liệu',now(),1);
END IF;


END $$

-- Execute the stored procedure
CALL V20200930182135__InsertUITranCatForPortal $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200930182135__InsertUITranCatForPortal $$
 
DELIMITER ;