DELIMITER $$
DROP PROCEDURE IF EXISTS V20201105175754__Create_enquiry_followup_details_view $$
CREATE PROCEDURE V20201105175754__Create_enquiry_followup_details_view()
BEGIN

IF EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'enquiry_followup_details_view')) THEN 
DROP view `enquiry_followup_details_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'enquiry_followup_details_view')) THEN 
Create Or Replace View enquiry_followup_details_view as
select a.Code as Lead_Id, a.EnquiryDate as Leaddate ,CONCAT(coalesce(b.firstName,''), ' ' ,coalesce(b.middleName,'') ,' ' ,coalesce(b.lastName,'')) as Owner, a.status as LeadStatus
,concat(coalesce(c.studentFirstName,'') ,' ',coalesce(c.studentMiddleName,''),' ',coalesce(c.studentLastName,'')) as Student_Name ,
g.id as User_id,g.printName as User_name,d.followUpDate as Follow_Up_Schedule_Date,
d.actualFollowUpDate as Follow_Up_Date ,e.itemCode as Follow_Up_Activity_Type,
d.followupReason_id as Reason_For_Follow_Up_id,f.itemValue as Follow_Up_Activity_Status, d.remark,
al.id as academyLocationId,al.academyName, al.academyCode,al.locationName,al.locationcode,
c.studentFirstName,c.studentLastName,
prog.programnametobeprint as Program_Name,prog.programShortName as Program_Short_Name,
prog.programCode,batch.printname as Intake,
iy.itemValue as Intake_Year,enqinter.type as Enquiry_Stage, enqp.Priority,
reasonff.itemvalue as Reason_For_Follow_Up,
modeod.itemValue as Mode_of_Delivery,
case when batch.batchPartTime = 1 then 'Part Time' when batch.batchPartTime=0 then 'Full Time' else null end as Registration_Type

from enquiry a
left join users b on(a.userId = b.id )
left join enq_student_details c on(c.enquiryId=a.id)
left join enq_followup d on(d.enquiryId=a.id )
left join users g on( d.userId=g.id)
left join follow_up_activity_type e on(d.followupActivityTypeId=e.id)
left join follow_up_activity_status f on(d.followupActivityStatusId=f.id)
left join academy_location al on(a.academyLocationId=al.id)
left join admission_enq_details admenq on(admenq.enqStudentDetailsId=c.id)
left join programs prog on(admenq.programId=prog.id)
left join batches batch on (admenq.batchId=batch.id)
left join intake_year iy on(batch.intakeYearId=iy.id)
left join enq_intermediate_type enqinter on(a.enqIntermediateStageId=enqinter.id)
left join enq_priority enqp on(enqp.id=a.enqPriorityId)
left join enq_followup enqf on(enqf.enquiryId=a.id)
left join reason_for_follow_up reasonff on(reasonff.id=enqf.followupReason_id)
left join mode_of_delivery modeod on(batch.modeOfDeliveryId=modeod.id)
group by a.id;
END IF; 

END $$
CALL V20201105175754__Create_enquiry_followup_details_view () $$ 
DROP PROCEDURE IF EXISTS V20201105175754__Create_enquiry_followup_details_view $$ 
DELIMITER ;