DELIMITER $$
DROP PROCEDURE IF EXISTS V20201110173755__Insert_ElectionIdGenerator $$
CREATE PROCEDURE V20201110173755__Insert_ElectionIdGenerator()
BEGIN


SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
IF NOT EXISTS ((select * from id_column_available where tableName="election" and columnName="electionCode")) THEN 
INSERT INTO id_column_available (tableName, columnName) VALUES('election','electionCode');
END IF;
IF NOT EXISTS ((select * from id_entity_setting where tableName="election" and idGenerationTable="election")) THEN 
INSERT INTO id_entity_setting ( tableName, idGenerationTable,whetherFullyConfigurable,dynanicFieldAvailable, searchConfigCode, lastUpdatedBy, lastUpdate) VALUES('election','election',TRUE,TRUE,NULL,1,@currentTimeStamp);
SET @idEntitySettingId=(select id from id_entity_setting where tableName="election" and idGenerationTable="election");
END IF; 
IF NOT EXISTS ((select * from id_definition where idEntitySettingId=@idEntitySettingId and idColumn="electionCode")) THEN 
INSERT  INTO id_definition(idEntitySettingId,idFormatType,idColumn,whetherManualId,whetherDefaultID,lastUpdatedBy,lastUpdate,VERSION) VALUES ( @idEntitySettingId,'ALPHA_NUMERIC','electionCode',0,0,1,@currentTimeStamp,0);
END IF; 
SET @idDefinitionId=(select id from id_definition where idEntitySettingId=@idEntitySettingId and idColumn="electionCode");
IF NOT EXISTS ((select * from id_format where idDefinitionId=@idDefinitionId)) THEN 
INSERT  INTO id_format(idDefinitionId,seqNo,lastUpdatedBy,lastUpdate) VALUES (@idDefinitionId,1,1,@currentTimeStamp);
SET @idFormat=(select id from id_format where idDefinitionId=@idDefinitionId);
END IF; 
IF NOT EXISTS ((select * from id_format_alphanumeric where id=@idFormat)) THEN 
INSERT  INTO id_format_alphanumeric(id,prefix,suffix,startFrom) VALUES (@idFormat,'ELECTION','',1);
END IF; 


END $$
CALL V20201110173755__Insert_ElectionIdGenerator() $$
DROP PROCEDURE IF EXISTS V20201110173755__Insert_ElectionIdGenerator $$
DELIMITER ;