DELIMITER $$
DROP PROCEDURE IF EXISTS V20201203143626__Alter_EmployeeOtherLanguageDetails $$
CREATE PROCEDURE V20201203143626__Alter_EmployeeOtherLanguageDetails()

BEGIN
  
IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='persons' 
   AND column_name in ('firstNameOtherLanguage','middleNameOtherLanguage','lastNameOtherLanguage','shortNameOtherLanguage','printNameOtherLanguage'))) THEN
   
   ALTER TABLE `persons` 
   ADD COLUMN  firstNameOtherLanguage varchar(255) NULL DEFAULT NULL,
   ADD COLUMN  middleNameOtherLanguage varchar(255) NULL DEFAULT NULL,
   ADD COLUMN  lastNameOtherLanguage varchar(255) NULL DEFAULT NULL,
   ADD COLUMN  shortNameOtherLanguage varchar(255) NULL DEFAULT NULL,
   ADD COLUMN  printNameOtherLanguage varchar(255) NULL DEFAULT NULL;
   END IF;
  


IF NOT EXISTS ((select * from ui_translation where keyName='PERSON' and objectName='FIRST_NAME_OTHER_LANGUAGE')) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('PERSON','FIRST_NAME_OTHER_LANGUAGE','First Name-Other Language','First Name-Other Language','Tên-Ngôn ngữ khác','Voornaam-ander taal',now(),1);
END IF; 

IF NOT EXISTS ((select * from ui_translation where keyName='PERSON' and objectName='MIDDLE_NAME_OTHER_LANGUAGE')) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('PERSON','MIDDLE_NAME_OTHER_LANGUAGE','Middle Name-Other Language','Middle Name-Other Language','Tên đệm-Ngôn ngữ khác','Middelnaam-ander taal',now(),1);
END IF; 

IF NOT EXISTS ((select * from ui_translation where keyName='PERSON' and objectName='LAST_NAME_OTHER_LANGUAGE')) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('PERSON','LAST_NAME_OTHER_LANGUAGE','Last Name-Other Language','Last Name-Other Language','Họ-Ngôn ngữ khác','Van-ander taal',now(),1);
END IF; 

IF NOT EXISTS ((select * from ui_translation where keyName='PERSON' and objectName='SHORT_NAME_OTHER_LANGUAGE')) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('PERSON','SHORT_NAME_OTHER_LANGUAGE','Short Name-Other Language','Short Name-Other Language','Tên ngắn-Ngôn ngữ khác','Kort naam-ander taal',now(),1);
END IF; 

IF NOT EXISTS ((select * from ui_translation where keyName='PERSON' and objectName='PRINT_NAME_OTHER_LANGUAGE')) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('PERSON','PRINT_NAME_OTHER_LANGUAGE','Print Name-Other Language','Print Name-Other Language','Tên in-Ngôn ngữ khác','Druk naam-ander taal',now(),1);
END IF; 

END $$

CALL V20201203143626__Alter_EmployeeOtherLanguageDetails $$
DROP PROCEDURE IF EXISTS V20201203143626__Alter_EmployeeOtherLanguageDetails $$
DELIMITER ;