DELIMITER $$
DROP PROCEDURE IF EXISTS V20201216202555__Insert_FBCDetailRecDuplicateClg $$
CREATE PROCEDURE V20201216202555__Insert_FBCDetailRecDuplicateClg()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE reportTypeId = '4' AND templateCode = 'MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE' AND templateName='FBC Receipt with Settlement Student End')) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES ('4','MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE', 'FBC Receipt with Settlement Student End', 'SettlementTriplicateCollege.png', 'CommonReport_LandScape_pageNo_LeftCenterRightAITBReceipt.jasper', 'All', '0', 'HeaderBlank_LandScape.jasper', 'FooterBlank.jasper', '0', '0', 'feeReceipt_Student_JLU.jasper', 'AcademiaLogo.png');

set @d1FBCReceiptSettleStudent = (select max(id) from report_template where templateCode ='MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d1FBCReceiptSettleStudent , 'TRANS_RECEIPTNO', 'Receipt No.', '1', NOW()),
(@d1FBCReceiptSettleStudent , 'TRANS_DATE', 'Date', '1', NOW()),
(@d1FBCReceiptSettleStudent , 'TRANS_RECEIVED_FROM', 'Received from', '1', NOW()),
(@d1FBCReceiptSettleStudent , 'TRANS_FATHER_NAME', 'Father Name', '1', NOW()),
(@d1FBCReceiptSettleStudent , 'TRANS_ID', 'Id', '1', NOW()),
(@d1FBCReceiptSettleStudent , 'TRANS_ACADEMY_NAME', 'Academy Name', '1', NOW()),
(@d1FBCReceiptSettleStudent , 'TRANS_PROGRAM_NAME', 'Program Name', '1', NOW()),
(@d1FBCReceiptSettleStudent , 'TRANS_PROCESSED_BY', 'Processed By', '1', NOW()),
(@d1FBCReceiptSettleStudent , 'TRANS_REMARK', 'Remark', '1', NOW()),
(@d1FBCReceiptSettleStudent , 'TRANS_SR_NO', 'Sr. No.', '1', NOW()),
(@d1FBCReceiptSettleStudent , 'TRANS_PARTICULAR', 'Particular', '1', NOW()),
(@d1FBCReceiptSettleStudent , 'TRANS_AMOUNT', 'Amount', '1', NOW()),
(@d1FBCReceiptSettleStudent , 'TRANS_BANK_NAME', 'Bank Name', '1', NOW()),
(@d1FBCReceiptSettleStudent , 'TRANS_NATIONALID', 'National ID / Passport NO.', '1', NOW());
END IF; 

END $$
CALL V20201216202555__Insert_FBCDetailRecDuplicateClg() $$
DROP PROCEDURE IF EXISTS V20201216202555__Insert_FBCDetailRecDuplicateClg $$
DELIMITER ;