DELIMITER $$
DROP PROCEDURE IF EXISTS V20201221212152__Alter_applicationRequiredDocumentsColumn $$
CREATE PROCEDURE V20201221212152__Alter_applicationRequiredDocumentsColumn()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='application_required_documents' AND column_name='applicationProgramId')) THEN 
ALTER TABLE `application_required_documents` 
ADD COLUMN `applicationProgramId` BIGINT NULL DEFAULT NULL AFTER `documentStatusId`,
ADD INDEX `application_required_document_fk_app_prog_idx` (`applicationProgramId` ASC);
ALTER TABLE `application_required_documents` 
ADD CONSTRAINT `application_required_document_fk_app_prog`
  FOREIGN KEY (`applicationProgramId`)
  REFERENCES `application_program` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='prog_slctn_process_document' AND column_name='isConditionalDocument')) THEN 
ALTER TABLE `prog_slctn_process_document` 
ADD COLUMN `isConditionalDocument` BIT(1) NULL DEFAULT NULL AFTER `version`;
END IF; 

END $$
CALL V20201221212152__Alter_applicationRequiredDocumentsColumn() $$
DROP PROCEDURE IF EXISTS V20201221212152__Alter_applicationRequiredDocumentsColumn $$
DELIMITER ;