DELIMITER $$

DROP PROCEDURE IF EXISTS V20202312143911__InsertUITranslationSocialRedirectURL $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20202312143911__InsertUITranslationSocialRedirectURL()

BEGIN
  
	-- Insert new record in ui_translation table, if it doesn't already exist
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ERRORMESSAGE' and keyName='SOCIAL_REDIRECT_URL_NOTUNIQUE')) THEN 
		INSERT INTO `ui_translation` 
		(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`,`lastUpdatedBy`)
		VALUES
		('ERRORMESSAGE','SOCIAL_REDIRECT_URL_NOTUNIQUE','Redirect URL Not Unique','Redirect URL Not Unique','Herlei URL nie uniek nie', 'URL chuyển hướng không phải là duy nhất',now(),1);
	END IF; 
  
END $$


-- Execute the stored procedure
CALL V20202312143911__InsertUITranslationSocialRedirectURL() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20202312143911__InsertUITranslationSocialRedirectURL $$
 
DELIMITER ;