DELIMITER $$
DROP PROCEDURE IF EXISTS V20210223120010__Update_Salutation_Display_Order_CSM $$
CREATE PROCEDURE V20210223120010__Update_Salutation_Display_Order_CSM()
BEGIN
SET SQL_SAFE_UPDATES=0;

SET @standardMasterId=(select id from standard_master where tableName = 'salutations');
IF EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId=@standardMasterId)) THEN 
UPDATE standard_master_items SET diaplayOrder = 2 
WHERE (dbFieldName = 'salutationName' AND standardMasterId=@standardMasterId);
END IF; 

SET @standardMasterId=(select id from standard_master where tableName = 'salutations');
IF EXISTS ((SELECT * FROM standard_master_items where standardMasterId=@standardMasterId)) THEN 
UPDATE standard_master_items SET diaplayOrder = 3 
WHERE (dbFieldName = 'salutationNameInOtherLanguage' AND standardMasterId=@standardMasterId);
END IF; 

SET SQL_SAFE_UPDATES=1;

-- adding new column Title Code

SET @standardMasterId=(select id from standard_master where tableName = 'salutations');
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE  dbFieldName='titleCode' AND fieldLabel='TITLE_CODE' AND standardMasterId=@standardMasterId)) THEN 
INSERT INTO standard_master_items( `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES ('titleCode', 'TITLE_CODE', @standardMasterId, 'Varchar', '1', 0, 0, 0, true, '1', SYSDATE());
END IF; 


-- translations

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'TITLE_CODE')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'TITLE_CODE', 'Title Code', 'Title Code','Titelkode','Mã tiêu đề',now(),1);
END IF;

END $$
CALL V20210223120010__Update_Salutation_Display_Order_CSM () $$
DROP PROCEDURE IF EXISTS V20210223120010__Update_Salutation_Display_Order_CSM $$
DELIMITER ;