DELIMITER $$
DROP PROCEDURE IF EXISTS V20210503095651__Create_manageHoldCategoryMapping $$
CREATE PROCEDURE V20210503095651__Create_manageHoldCategoryMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='manage_hold_category_mapping')) THEN 
CREATE TABLE `manage_hold_category_mapping` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `holdCategoryId` bigint NOT NULL,
  `progBatchSeatConfigId` bigint NOT NULL,
  `lastUpdatedBy` bigint DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_hold_cat_id_idx` (`holdCategoryId`),
  KEY `fk_prog_batch_config_id_idx` (`progBatchSeatConfigId`),
  KEY `fk_mapping_last_updated_by_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_hold_cat_id` FOREIGN KEY (`holdCategoryId`) REFERENCES `manage_hold_category` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_mapping_last_updated_by` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_prog_batch_config_id` FOREIGN KEY (`progBatchSeatConfigId`) REFERENCES `prog_batch_seat_config` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20210503095651__Create_manageHoldCategoryMapping () $$ 
DROP PROCEDURE IF EXISTS V20210503095651__Create_manageHoldCategoryMapping $$ 
DELIMITER ;