DROP PROCEDURE IF EXISTS updateCalculationStatus;
DELIMITER $$
CREATE DEFINER=`ss_root`@`localhost` PROCEDURE `updateCalculationStatus`(
IN admissionId BIGINT(20),
IN periodId BIGINT(20),
IN courseVariantId BIGINT(20),
IN sectionId BIGINT(20),
IN lastUpdate timestamp
)
BEGIN
START TRANSACTION;

 BLOCK1: begin
set sql_safe_updates=0;
if(courseVariantId is not null) then
update examination_result result
set result.calculationDone = true,result.lastUpdate = lastUpdate

where result.admissionId=admissionId and result.periodId=periodId and result.courseVariantId=courseVariantId
and result.sectionId=sectionId and result.finalGrade is not null or result.finalMarks is not null;
else
update examination_result result
set result.calculationDone = true,result.lastUpdate = lastUpdate
where result.admissionId=admissionId and result.periodId=periodId and result.courseVariantId is null
and result.sectionId=sectionId;
end if;
set sql_safe_updates=1;

	END BLOCK1;

COMMIT;        
END$$
DELIMITER ;