DELIMITER $$
DROP PROCEDURE IF EXISTS V20210512124253__Update_ManageReceipt_Applicant_dataGrid $$
CREATE PROCEDURE V20210512124253__Update_ManageReceipt_Applicant_dataGrid()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF EXISTS ((select * from data_grid where gridName="Academia.view.feeandpayment.receipts.ReceiptHeaderListForApplicant" and portalId=1)) THEN 
UPDATE `data_grid` SET `jsonObject` =
'[{"id":null,"columnName":"ACADEMY","dataIndex":"academyName","columnVisibility":"SHOW","sequence":1,"mandatory":false},
{"id":null,"columnName":"LOCATION","dataIndex":"locationName","columnVisibility":"SHOW","sequence":2,"mandatory":false},
{"id":null,"columnName":"PROGRAM","dataIndex":"programNameToBePrint","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"BATCH","dataIndex":"batchName","columnVisibility":"SHOW","sequence":4,"mandatory":false},
{"id":null,"columnName":"SEAT_NAME","dataIndex":"seatName","columnVisibility":"HIDE","sequence":5,"mandatory":false},
{"id":null,"columnName":"APPLICANT_ID","dataIndex":"applicantCode","columnVisibility":"SHOW","sequence":6,"mandatory":false},
{"id":null,"columnName":"NATIONAL_ID","dataIndex":"nationalID","columnVisibility":"HIDE","sequence":7,"mandatory":false},
{"id":null,"columnName":"APPLICANT_NAME","dataIndex":"personPrintName","columnVisibility":"SHOW","sequence":8,"mandatory":false},
{"id":null,"columnName":"APPLICANT_FIRST_NAME","dataIndex":"personFirstName","columnVisibility":"HIDE","sequence":9,"mandatory":false},
{"id":null,"columnName":"APPLICANT_MIDDLE_NAME","dataIndex":"personMiddleName","columnVisibility":"HIDE","sequence":10,"mandatory":false},
{"id":null,"columnName":"APPLICANT_LAST_NAME","dataIndex":"personLastName","columnVisibility":"HIDE","sequence":11,"mandatory":false},
{"id":null,"columnName":"FATHER_NAME","dataIndex":"fatherFullName","columnVisibility":"SHOW","sequence":12,"mandatory":false},
{"id":null,"columnName":"RECEIPT_NUMBER","dataIndex":"receiptNo","columnVisibility":"SHOW","sequence":13,"mandatory":false},
{"id":null,"columnName":"RECEIPT_MODE","dataIndex":"receiptType","columnVisibility":"SHOW","sequence":14,"mandatory":false},
{"id":null,"columnName":"SETTLEMENT_STATUS","dataIndex":"status","columnVisibility":"SHOW","sequence":15,"mandatory":false},
{"id":null,"columnName":"CANCELLATION_REASON","dataIndex":"cancellationNarration","columnVisibility":"HIDE","sequence":16,"mandatory":false},
{"id":null,"columnName":"AMOUNT","dataIndex":"amount","columnVisibility":"SHOW","sequence":17,"mandatory":false},
{"id":null,"columnName":"CURRENCY_EXCHANGE_RATE","dataIndex":"currencyExchangeRate","columnVisibility":"SHOW","sequence":18,"mandatory":false},
{"id":null,"columnName":"CONVERTED_AMOUNT","dataIndex":"convertedAmountRandB","columnVisibility":"SHOW","sequence":19,"mandatory":false},
{"id":null,"columnName":"RECEIPT_DATE","dataIndex":"transactionDate","columnVisibility":"SHOW","sequence":20,"mandatory":false},
{"id":null,"columnName":"REMARKS","dataIndex":"remarks","columnVisibility":"SHOW","sequence":21,"mandatory":false},
{"id":null,"columnName":"PAYMENT_MODE","dataIndex":"paymentModeName","columnVisibility":"HIDE","sequence":22,"mandatory":false},
{"id":null,"columnName":"OUR_BANK_ACCOUNT","dataIndex":"bankName","columnVisibility":"HIDE","sequence":23,"mandatory":false},
{"id":null,"columnName":"RECEIPT_CURRENCY","dataIndex":"currencyName","columnVisibility":"HIDE","sequence":24,"mandatory":false},
{"id":null,"columnName":"ADJUSTMENT_DETAILS","dataIndex":"adjustmentDetails","columnVisibility":"SHOW","sequence":25,"mandatory":false},
{"id":null,"columnName":"INSTRUMENT_DETAILS","dataIndex":"instrumentDetails","columnVisibility":"SHOW","sequence":26,"mandatory":false},
{"id":null,"columnName":"COST_CENTER","dataIndex":"costCentre","columnVisibility":"HIDE","sequence":27,"mandatory":false}]'
where gridName="Academia.view.feeandpayment.receipts.ReceiptHeaderListForApplicant" and portalId=1;
END IF; 
 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20210512124253__Update_ManageReceipt_Applicant_dataGrid () $$
DROP PROCEDURE IF EXISTS V20210512124253__Update_ManageReceipt_Applicant_dataGrid $$
DELIMITER ;
