DELIMITER //

DROP PROCEDURE IF EXISTS sp_tvet_staffqualificationdetails //

CREATE  PROCEDURE sp_tvet_staffqualificationdetails(in p_alid varchar(1000))
BEGIN

select usr.code as Staff_Number,
eduhcd.cf11 as Staff_Qualification_Type_Id,
eduh.yearOfExamination as Achievement_Year
,loc.shortCode as Provider_Code,
541 as Provider_ETQE_Id,
DATE_FORMAT(NOW(), '%Y%m%d') as Date_Stamp
from staffs staf  join persons per on(staf.personId=per.id)
join users usr on(usr.id=staf.userid)
left join education_histories eduh on (per.id=eduh.personid)
left join education_history_cd eduhcd on (eduh.id=eduhcd.educationhistoryid)
left join user_academy_locations alpur on(usr.id=alpur.userid)
left join academy_location al on(alpur.academyLocationId=al.id)
left join locations loc on(al.locationId=loc.id)
where eduhcd.cf11 is not null and  FIND_IN_SET( al.id,p_alid)
group by staf.userid;

END//
DELIMITER ;