DELIMITER $$
DROP PROCEDURE IF EXISTS V20210528161112__Insert_CrossListRGI $$
CREATE PROCEDURE V20210528161112__Insert_CrossListRGI()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'CROSS_LIST_FOR_STUDENT_RGI' )) THEN 
set @cross1 = (select id from report_type WHERE typeName = 'Cross List Report');

INSERT INTO report_template (reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, templateType, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo) 
VALUES(@cross1, 'CROSS_LIST_FOR_STUDENT_RGI', 'Cross List Report for Student RGI', 'CROSS_LIST_FOR_STUDENT_RGI.png', 'CommonReport_Excel.jasper',NULL, 'All', '1', 'FooterBlank.jasper', 'Footer_CROSSLIST_RGI.jasper', '1', '1', 'CROSS_LIST_FOR_STUDENT_RGI.jasper', 'AcademiaLogo.png');

END IF;


IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'CROSS_LIST_FOR_STUDENT_RGI')) THEN 
set @list = (select max(id) from `report_template` WHERE templateCode = 'CROSS_LIST_FOR_STUDENT_RGI');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @list and keyValue='TRANS_LIST_OF_FAIL_STD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@list, 'TRANS_LIST_OF_FAIL_STD', 'List of Fail Students', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @list and keyValue='TRANS_NUM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@list, 'TRANS_NUM', 'No :', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @list and keyValue='TRANS_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@list, 'TRANS_DATE', 'Date :', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @list and keyValue='TRANS_SCHOOL_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@list, 'TRANS_SCHOOL_NAME', 'School Name :', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @list and keyValue='TRANS_DEPARTMENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@list, 'TRANS_DEPARTMENT_NAME', 'Department Name :', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @list and keyValue='TRANS_SERIAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@list, 'TRANS_SERIAL', 'S.No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @list and keyValue='TRANS_STD_ROLL_NUM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@list, 'TRANS_STD_ROLL_NUM', 'Roll No.', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @list and keyValue='TRANS_STD_ENROLLMENT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@list, 'TRANS_STD_ENROLLMENT', 'Enrollment No.', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @list and keyValue='TRANS_STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@list, 'TRANS_STUDENT_NAME', 'Name of Student', '1', now());
END IF;


END $$
CALL V20210528161112__Insert_CrossListRGI() $$
DROP PROCEDURE IF EXISTS V20210528161112__Insert_CrossListRGI $$
DELIMITER ;
