DELIMITER $$
DROP PROCEDURE IF EXISTS V20210616193932__Insert_HeadwiseReport_GNA $$
CREATE PROCEDURE V20210616193932__Insert_HeadwiseReport_GNA()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'FEE_HEADWISE_REPORT_WITH_RECURRING_DISCOUNT' )) THEN 
set @head = (select id from report_type WHERE typeName = 'Fee Head Report');

INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`,`documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`,`repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)

VALUES (@head, 'FEE_HEADWISE_REPORT_WITH_RECURRING_DISCOUNT', 'Fee Head Wise Report with Recurring Discount', 'FEE_HEADWISE_REPORT_WITH_RECURRING_DISCOUNT.png', 'CommonReport_Excel.jasper','All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0','0', 'FEE_HEADWISE_REPORT_WITH_RECURRING_DISCOUNT.jasper', 'AcademiaLogo.jpg');
END IF; 


IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'FEE_HEADWISE_REPORT_WITH_RECURRING_DISCOUNT')) THEN 
set @wise = (select max(id) from `report_template` WHERE templateCode = 'FEE_HEADWISE_REPORT_WITH_RECURRING_DISCOUNT');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_SERIAL_NUM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_SERIAL_NUM', 'Sr.No', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_PROGRAM_CATEGORY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_PROGRAM_CATEGORY', 'Program Category', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_PROGRAM_GROUP')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_PROGRAM_GROUP', 'Program Group', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_PROGRAM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_PROGRAM', 'Program', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_BATCH')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_BATCH', 'Batch', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_CURRENT_SEM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_CURRENT_SEM', 'Current Sem', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_SEAT_TYPE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_SEAT_TYPE', 'Seat type', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_STUDENT_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_STUDENT_ID', 'Student ID', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_STUDENT_NAME', 'Student Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_BILL_NUM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_BILL_NUM', 'Bill no.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_BILL_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_BILL_DATE', 'Bill Date', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_DUE_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_DUE_DATE', 'Due date', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_BILL_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_BILL_AMOUNT', 'Bill Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_ADHOC_DIS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_ADHOC_DIS', 'Adhoc Discount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_RECURRING_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_RECURRING_AMOUNT', 'RecurringDiscount Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_AMOUNT_PAID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_AMOUNT_PAID', 'Amount Paid', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_OUTSTANDING_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_OUTSTANDING_AMOUNT', 'Outstanding Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_FEE_HEAD_WISE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_FEE_HEAD_WISE', 'Fee head-wise', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_FEE_HEAD_HEADING')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_FEE_HEAD_HEADING', 'Fee Head Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @wise and keyValue='TRANS_AMOUNT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@wise, 'TRANS_AMOUNT', 'Amount', '1', now());
END IF;

END $$
CALL V20210616193932__Insert_HeadwiseReport_GNA() $$
DROP PROCEDURE IF EXISTS V20210616193932__Insert_HeadwiseReport_GNA $$
DELIMITER ;
