DELIMITER $$
DROP PROCEDURE IF EXISTS V20210708151810__Create_Velocity_manage_target_analytics $$
CREATE PROCEDURE V20210708151810__Create_Velocity_manage_target_analytics()
BEGIN

DROP VIEW IF EXISTS velocity_manage_target_analytics;
	
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='velocity_manage_target_analytics')) THEN 

CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `velocity_manage_target_analytics` AS
    SELECT 
        `mt`.`academyLocationId` AS `academyLocationId`,
        `al`.`academyCode` AS `academyCode`,
        `al`.`academyName` AS `academyName`,
        `al`.`displayName` AS `displayName`,
        `al`.`locationCode` AS `locationCode`,
        `al`.`locationName` AS `locationName`,
        `progroup`.`groupName` AS `Program_Group`,
        `prog`.`programCode` AS `programCode`,
        `prog`.`programName` AS `programName`,
        `prog`.`programShortName` AS `programShortName`,
        `btc`.`batchName` AS `batchName`,
        `iy`.`itemValue` AS `Intake_Year`,
        `mt`.`enquiryTarget` AS `enquiryTarget`,
        `mt`.`applicationTarget` AS `applicationTarget`,
        `mt`.`enrolmentPreviousYear` AS `enrolmentPreviousYear`,
        `mt`.`enrolmentTarget` AS `enrolmentTarget`,
        `mt`.`enrolmentBudget` AS `enrolmentBudget`,
        `mt`.`revisedBudget` AS `revisedBudget`,
        `mt`.`buildingCapacity` AS `buildingCapacity`,
        `mt`.`buildingCapacitySpecialist` AS `buildingCapacitySpecialist`,
        `mt`.`returningStudents` AS `returningStudents`
    FROM
        (((((`manage_target` `mt`
        LEFT JOIN `academy_location` `al` ON ((`al`.`id` = `mt`.`academyLocationId`)))
        LEFT JOIN `programs` `prog` ON ((`prog`.`id` = `mt`.`programId`)))
        LEFT JOIN `program_group` `progroup` ON ((`progroup`.`id` = `mt`.`programGroupId`)))
        LEFT JOIN `batches` `btc` ON ((`btc`.`id` = `mt`.`batchId`)))
        LEFT JOIN `intake_year` `iy` ON ((`iy`.`id` = `mt`.`intakeYearId`)));

END IF; 

END $$
CALL V20210708151810__Create_Velocity_manage_target_analytics () $$ 
DROP PROCEDURE IF EXISTS V20210708151810__Create_Velocity_manage_target_analytics $$ 
DELIMITER ;