DELIMITER $$
DROP PROCEDURE IF EXISTS V20210818185052__Insert_UITranslations_RegistraionTerm $$
CREATE PROCEDURE V20210818185052__Insert_UITranslations_RegistraionTerm()
BEGIN

IF NOT EXISTS (((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='PRE_REGISTRATION_TERMS_CONDITIONS'))) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','PRE_REGISTRATION_TERMS_CONDITIONS','Pre-Registration Terms and Conditions','Pre-Registration Terms and Conditions','Voorwaardes en voorregistrasie','Điều khoản và điều kiện đăng ký trước',now(),1);
END IF; 

IF NOT EXISTS (((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='REGISTRATION_CONTRACT'))) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','REGISTRATION_CONTRACT','Registration Contract','Registration Contract','Registrasie kontrak','Hợp đồng đăng ký',now(),1);
END IF; 

IF NOT EXISTS (((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='PRE_REGISTRAION_TERM_APPLICABLE'))) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','PRE_REGISTRAION_TERM_APPLICABLE','Pre-Registration Terms and Conditions Applicable?','Pre-Registration Terms and Conditions Applicable?','Voorwaardes en voorwaardes voor registrasie van toepassing?','Điều khoản và điều kiện đăng ký trước có áp dụng không?',now(),1);
END IF; 

IF NOT EXISTS (((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='TERMS_AND_CONDITION_LINK'))) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','TERMS_AND_CONDITION_LINK','Terms and Conditions Link','Terms and Conditions Link','Skakel terme en voorwaardes','Liên kết Điều khoản và Điều kiện',now(),1);
END IF; 

IF NOT EXISTS (((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='REGISTRATION_CONTRACT_APPLICABLE'))) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','REGISTRATION_CONTRACT_APPLICABLE','Registration Contract Applicable?','Registration Contract Applicable?','Registrasiekontrak van toepassing?','Hợp đồng đăng ký có thể áp dụng?',now(),1);
END IF; 

IF NOT EXISTS (((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='PRE_REG_WIN_CONTENT_LINE1'))) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','PRE_REG_WIN_CONTENT_LINE1','We are delighted to welcome you as a student of [ACADEMY_LOCATION], Please read and accept the Terms and Conditions and the Rules and Regulations of the [ACADEMY_LOCATION] below before proceeding to complete your Online Registration. Before proceeding - please ensure you are aware of all modules which must be undertaken. If you are not sure - please contact the campus or visit the brand website [XXXXX]','We are delighted to welcome you as a student of [ACADEMY_LOCATION], Please read and accept the Terms and Conditions and the Rules and Regulations of the [ACADEMY_LOCATION] below before proceeding to complete your Online Registration. Before proceeding - please ensure you are aware of all modules which must be undertaken. If you are not sure - please contact the campus or visit the brand website [XXXXX]','Ons is verheug om u as student van [ACADEMY_LOCATION] te verwelkom. Lees en aanvaar die bepalings en voorwaardes en die reëls en regulasies van die [ACADEMY_LOCATION] hieronder voordat u u aanlynregistrasie voltooi. Voordat u verder gaan - maak asseblief seker dat u bewus is van alle modules wat uitgevoer moet word. As u nie seker is nie - kontak die kampus of besoek die handelsmerkwebwerf [XXXXX]','Chúng tôi rất vui mừng chào đón bạn với tư cách là học viên của [ACADEMY_LOCATION], Vui lòng đọc và chấp nhận các Điều khoản và Điều kiện cũng như Quy tắc và Quy định của [ACADEMY_LOCATION] bên dưới trước khi hoàn tất Đăng ký Trực tuyến của bạn. Trước khi tiếp tục - hãy đảm bảo rằng bạn biết tất cả các mô-đun phải được thực hiện. Nếu bạn không chắc chắn - vui lòng liên hệ với khuôn viên trường hoặc truy cập trang web thương hiệu [XXXXX]',now(),1);
END IF; 

IF NOT EXISTS (((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='PRE_REG_WIN_CONTENT_LINE2'))) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','PRE_REG_WIN_CONTENT_LINE2','Please note you may click the Save and Exit button on the various screens to save your progress and to return to complete your Online Registration at a later stage.','Please note you may click the Save and Exit button on the various screens to save your progress and to return to complete your Online Registration at a later stage.','Let asseblief daarop dat u op die knoppie Stoor en verlaat op die verskillende skerms kan klik om u vordering te stoor en om later terug te keer om u aanlynregistrasie te voltooi.','Xin lưu ý rằng bạn có thể nhấp vào nút Lưu và Thoát trên các màn hình khác nhau để lưu tiến trình của mình và quay lại để hoàn tất Đăng ký Trực tuyến ở giai đoạn sau.',now(),1);
END IF; 

IF NOT EXISTS (((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='ACCEPT_AND_CONTINUE'))) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','ACCEPT_AND_CONTINUE','Accept and Continue','Accept and Continue','Aanvaar en gaan voort','Chấp nhận và tiếp tục',now(),1);
END IF; 

END $$
CALL V20210818185052__Insert_UITranslations_RegistraionTerm() $$
DROP PROCEDURE IF EXISTS V20210818185052__Insert_UITranslations_RegistraionTerm $$
DELIMITER ;