DELIMITER $$
DROP PROCEDURE IF EXISTS V20210830121051__Create_ApplicantLanguageCompetency $$
CREATE PROCEDURE V20210830121051__Create_ApplicantLanguageCompetency()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_language_competency')) THEN 
CREATE TABLE `applicant_language_competency` (
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
  	`personId` bigint(20) NOT NULL,
 	`multilangId` bigint(20) DEFAULT NULL,
  	`speakNo` bigint(20) DEFAULT NULL,
  	`readNo` bigint(20) DEFAULT NULL,
  	`writeNo`bigint(20) DEFAULT NULL,
	`lastUpdatedBy` bigint(20) DEFAULT NULL,
 	`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  	PRIMARY KEY (`id`),
  	KEY `fk_applicant_language_competency_lastupdatedby_idx` (`lastUpdatedBy`),
	KEY `fk_applicant_language_competency_applicantPersonId_idx` (`personId`),
 	KEY `fk_applicant_language_competency_multilangId_idx` (`multilangId`),
	CONSTRAINT `fk_applicant_language_competency_multilangId` FOREIGN KEY (`multilangId`) REFERENCES `multi_language` (`id`),
	CONSTRAINT `fk_applicant_language_competency_applicantPersonId` FOREIGN KEY (`personId`) REFERENCES `applicant_person` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
 	CONSTRAINT `fk_applicant_language_competency_lastupdatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`));
END IF; 

END $$
CALL V20210830121051__Create_ApplicantLanguageCompetency () $$ 
DROP PROCEDURE IF EXISTS V20210830121051__Create_ApplicantLanguageCompetency $$ 
DELIMITER ;