DELIMITER $$
DROP PROCEDURE IF EXISTS V20211028161904__Create_FormFieldInformation $$
CREATE PROCEDURE V20211028161904__Create_FormFieldInformation()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='form_field_information')) THEN 
CREATE TABLE `form_field_information` (
  `id` BIGINT(20) NOT NULL,
  `formName` VARCHAR(255) NOT NULL,
  `formAliasName` VARCHAR(255) NOT NULL,
  `fieldId` VARCHAR(100) NOT NULL,
  `fieldName` VARCHAR(100) NOT NULL,
  `fieldDisplayName` VARCHAR(255) NOT NULL,
  `isEditable` BIT(1) NOT NULL,
  `isLocked` BIT(1) NOT NULL,
  `moduleInformationId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL DEFAULT 1,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  INDEX `fk_form_field_info_module_info_idx` (`moduleInformationId` ASC),
  INDEX `fk_form_field_info_users_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_form_field_info_module_info`
    FOREIGN KEY (`moduleInformationId`)
    REFERENCES `module_information` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_form_field_info_users`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20211028161904__Create_FormFieldInformation () $$ 
DROP PROCEDURE IF EXISTS V20211028161904__Create_FormFieldInformation $$ 
DELIMITER ;