DELIMITER $$
DROP PROCEDURE IF EXISTS V20211118183201__Create_ProgramAreaOfInterest $$
CREATE PROCEDURE V20211118183201__Create_ProgramAreaOfInterest()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_area_of_interest')) THEN 
CREATE TABLE `program_area_of_interest` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `programId` bigint NOT NULL,
  `areaOfInterestId` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_program_area_of_interest_program_id` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`),
  CONSTRAINT `fk_program_area_of_interest_areaOfInterest_id` FOREIGN KEY (`areaOfInterestId`) REFERENCES `area_of_interest` (`id`)
) ;
END IF; 

END $$
CALL V20211118183201__Create_ProgramAreaOfInterest () $$ 
DROP PROCEDURE IF EXISTS V20211118183201__Create_ProgramAreaOfInterest $$ 
DELIMITER ;