DELIMITER $$
DROP PROCEDURE IF EXISTS V20211221165009__Insert_CONSOLIDATED_INTERNAL_MARKS_REPORT $$
CREATE PROCEDURE V20211221165009__Insert_CONSOLIDATED_INTERNAL_MARKS_REPORT()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Internal Reports' );

IF NOT EXISTS (select * from report_template where `templateCode`='CONSOLIDATED_INTERNAL_MARKS_REPORT') THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'CONSOLIDATED_INTERNAL_MARKS_REPORT', 'Consolidated Internal marks report', 'CONSOLIDATED_INTERNAL_MARKS_REPORT.png', 'CommonReport_RGI_Internal_LandScape_A3Size.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'CONSOLIDATED_INTERNAL_MARKS_REPORT.jasper', 'AcademiaLogo.png');
END IF; 

set @reportTempId = (select max(id) from report_template where templateCode='CONSOLIDATED_INTERNAL_MARKS_REPORT' and templateName='Consolidated Internal marks report');

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_PROGRAM') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_PROGRAM', 'Program', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_BATCH') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_BATCH', 'Batch', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_SEMESTER') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_SEMESTER', 'Semester', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_SECTION') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_SECTION', 'Section', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_SN') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_SN', 'SN', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_ROLL_NO') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_ROLL_NO', 'Roll NO.', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_ENROLLMENT_NUMBER') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_ENROLLMENT_NUMBER', 'Enrollment Number', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_STUDENT_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_STUDENT_NAME', 'Name', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_TOTAL_STUDENTS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_TOTAL_STUDENTS', 'Total Students', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_AVERAGE_MARKS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_AVERAGE_MARKS', 'Average Marks', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_DATE_TIME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_DATE_TIME', 'Date&Time', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_TOTAL') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_TOTAL', 'Total', NOW());
END IF;	
IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_COURSE_SEQ') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_COURSE_SEQ', 'Course', NOW());
	
	
END IF;



END $$
CALL V20211221165009__Insert_CONSOLIDATED_INTERNAL_MARKS_REPORT() $$
DROP PROCEDURE IF EXISTS V20211221165009__Insert_CONSOLIDATED_INTERNAL_MARKS_REPORT $$
DELIMITER  ;