DELIMITER $$
DROP PROCEDURE IF EXISTS V20220208110951__Insert_DIT_CBCS_GRADE_CARD $$
CREATE PROCEDURE V20220208110951__Insert_DIT_CBCS_GRADE_CARD()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Mark Sheet' );

IF NOT EXISTS ((select * from report_template where templateCode = 'DIT_CBCS_PROVISIONAL_GRADE_CARD')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'DIT_CBCS_PROVISIONAL_GRADE_CARD', 'DIT CBCS Provisional Grade Card', 'DIT_CBCS_PROVISIONAL_GRADE_CARD.png', 'CommonReport_DIT_Provisional_Grade_card.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'DIT_CBCS_PROVISIONAL_GRADE_CARD.jasper', 'AcademiaLogo.png');
END IF; 


IF NOT EXISTS ((select * from report_template where templateCode = 'DIT_CBCS_ORIGINAL_GRADE_CARD')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'DIT_CBCS_ORIGINAL_GRADE_CARD', 'DIT CBCS Original Grade Card', 'DIT_CBCS_ORIGINAL_GRADE_CARD.png', 'CommonReport_DIT_CBCS_Original.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'DIT_CBCS_ORIGINAL_GRADE_CARD.jasper', 'AcademiaLogo.png');
END IF; 

set @provisionalGradeCard = (select max(id) from report_template where templateCode='DIT_CBCS_PROVISIONAL_GRADE_CARD' and templateName='DIT CBCS Provisional Grade Card');

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @provisionalGradeCard AND keyValue='TRANS_PROVISIONAL_GRADE_CARD') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@provisionalGradeCard, 'TRANS_PROVISIONAL_GRADE_CARD', 'Provisional Grade Card', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @provisionalGradeCard AND keyValue='TRANS_DATE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@provisionalGradeCard, 'TRANS_DATE', 'Date', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @provisionalGradeCard AND keyValue='TRANS_ROLL_NO') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@provisionalGradeCard, 'TRANS_ROLL_NO', 'Roll No', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @provisionalGradeCard AND keyValue='TRANS_ENROLL_NO') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@provisionalGradeCard, 'TRANS_ENROLL_NO', 'Enrollment No', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @provisionalGradeCard AND keyValue='TRANS_STUDENT_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@provisionalGradeCard, 'TRANS_STUDENT_NAME', 'Name of the Student', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @provisionalGradeCard AND keyValue='TRANS_FATHER_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@provisionalGradeCard, 'TRANS_FATHER_NAME', "Father's Name", '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @provisionalGradeCard AND keyValue='TRANS_PROGRAM') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@provisionalGradeCard, 'TRANS_PROGRAM', 'Programme', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @provisionalGradeCard AND keyValue='TRANS_COURSE_CODE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@provisionalGradeCard, 'TRANS_COURSE_CODE', 'Course Code', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @provisionalGradeCard AND keyValue='TRANS_COURSE_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@provisionalGradeCard, 'TRANS_COURSE_NAME', 'Course Name', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @provisionalGradeCard AND keyValue='TRANS_CREDIT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@provisionalGradeCard, 'TRANS_CREDIT', 'Credit', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @provisionalGradeCard AND keyValue='TRANS_GRADE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@provisionalGradeCard, 'TRANS_GRADE', 'Grade', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @provisionalGradeCard AND keyValue='TRANS_NOTE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@provisionalGradeCard, 'TRANS_NOTE', 'Disclaimer: Note that, This is system generated grade card. Hence at any stage, if it is found incorrect due to any valid reason, after due verification, this will lead to a change in the grades and corresponding CGPA and SGPA.', '1', now());
END IF;	



END $$
CALL V20220208110951__Insert_DIT_CBCS_GRADE_CARD() $$
DROP PROCEDURE IF EXISTS V20220208110951__Insert_DIT_CBCS_GRADE_CARD $$
DELIMITER ;