DELIMITER $$
DROP PROCEDURE IF EXISTS V20220214165811__Create_createManageApplicationStatus $$
CREATE PROCEDURE V20220214165811__Create_createManageApplicationStatus()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='placement_manage_job_application_status')) THEN
CREATE TABLE `placement_manage_job_application_status` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `studentId` bigint DEFAULT NULL,
  `campusId` bigint DEFAULT NULL,
  `progBatchSeatConfigId` bigint DEFAULT NULL,
  `admissionId` bigint DEFAULT NULL,
  `status` VARCHAR(255)  DEFAULT NULL,
  `lastUpdatedBy` bigint DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_student_id_idx` (`studentId`),
   KEY `fk_campus_id_idx` (`campusId`),
  KEY `fk_prog_batch_config_id_idx` (`progBatchSeatConfigId`),
  KEY `fk_admission_id_idx` (`admissionId`),
  KEY `fk_mapping_last_updated_by_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_student_id` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_campus_id` FOREIGN KEY (`campusId`) REFERENCES `placement_campus` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_plce_app_status_last_updated_by` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_plce_app_status_prog_batch_config_id` FOREIGN KEY (`progBatchSeatConfigId`) REFERENCES `prog_batch_seat_config` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_admission_id` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


END IF; 

END $$
CALL V20220214165811__Create_createManageApplicationStatus() $$
DROP PROCEDURE IF EXISTS V20220214165811__Create_createManageApplicationStatus $$
DELIMITER ;